/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.init;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.atp.base.service.IdGenerator;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InitWebClusterConfig {
    @Autowired
    private WebClusterConfig webClusterConfig;
    @Autowired
    NodeInfoConfig nodeInfoConfig;
    @Value(value="${spring.application.name}")
    String containerName;
    @Value(value="${redis.hashTags:false}")
    private Boolean hashTags;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    private IdGenerator idGenerator;

    @Bean
    @PostConstruct
    public void initWebClusterConfigBean() {
        String name = this.constantBaseVersion.getWEB_NODES_HEARTBEAT() + this.nodeInfoConfig.getClusterId() + "-" + this.nodeInfoConfig.getNodeIp() + "-" + this.nodeInfoConfig.getPort() + "-<" + this.containerName + ">-" + this.idGenerator.randomUUID();
        if (Boolean.FALSE.equals(this.hashTags)) {
            name = name.replace("{", "").replace("}", "");
        }
        this.webClusterConfig.setName(name);
    }
}

