/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.pubsub.mq;

import cn.hutool.core.convert.Convert;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.abilityweb.config.init.InitWebClusterConfig;
import com.ohaotian.abilityweb.config.pubsub.ChannelNaming;
import com.ohaotian.abilityweb.config.pubsub.mq.PubSubMqConsumer;
import com.ohaotian.abilityweb.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"initWebClusterConfigBean"})
@Configuration
public class PubSubMqConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PubSubMqConfiguration.class);
    @Autowired
    private PubSubResProperties pubSubResProperties;
    @Autowired
    private InitWebClusterConfig initWebClusterConfig;
    @Resource
    private WebClusterConfig webClusterConfig;

    @Bean(value={"defaultExteriorProxyMessageConfig"})
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(ChannelNaming.get(this.pubSubResProperties.getWeb2admin()) + "_" + ChannelNaming.get(this.webClusterConfig.getName()));
        return defaultProxyMessageConfig;
    }

    @Bean(value={"exteriorProvider"}, initMethod="startup", destroyMethod="shutdown")
    public ProxyProducerFactoryBean exteriorProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)this.defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean
    @PostConstruct
    public PubSubMqConsumer exteriorMqConsumer() {
        log.info("\u7cfb\u7edf\u88c5\u8f7dMQ\u6570\u636e\u6d88\u8d39\u8005\uff1aPubSubMqConsumer");
        PubSubMqConsumer pubSubMqConsumer = new PubSubMqConsumer();
        pubSubMqConsumer.setId(ChannelNaming.get(this.webClusterConfig.getName()));
        pubSubMqConsumer.setTags(Convert.toStrArray((Object)ChannelNaming.get(this.webClusterConfig.getName())));
        pubSubMqConsumer.setSubject(ChannelNaming.get(this.pubSubResProperties.getAdmin2web()));
        log.info("MQ \u8ba2\u9605\u901a\u9053\uff1atopic={} tags={} id={}", new Object[]{pubSubMqConsumer.getSubject(), pubSubMqConsumer.getTags(), pubSubMqConsumer.getId()});
        return pubSubMqConsumer;
    }

    @Autowired
    public PubSubMqConfiguration() {
    }
}

