/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.pubsub.mq;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.config.pubsub.ChannelNaming;
import com.ohaotian.abilityweb.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PubSubMqProvider {
    private static final Logger log = LoggerFactory.getLogger(PubSubMqProvider.class);
    @Resource(name="exteriorProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Resource
    NodeInfoConfig nodeInfo;
    @Autowired
    private PubSubResProperties pubSubResProperties;
    @Value(value="${atp.channel.value.size:200}")
    private int channelValueSize;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    public void provideMessage(String topic, String value) {
        Object sendResult = null;
        try {
            Object master = this.cacheClient.get(this.constantBaseVersion.getMASTER_NAME());
            Map node = GsonUtil.toStringMap((String)master.toString());
            ProxyMessage proxyMessage = new ProxyMessage(ChannelNaming.get(this.pubSubResProperties.getWeb2admin()), ChannelNaming.get(node.get("name")), value);
            this.proxyMessageProducer.send(proxyMessage);
            log.info("MQ \u63a8\u9001\u901a\u9053\uff1atopic={} tag={} value={}", new Object[]{proxyMessage.getSubject(), proxyMessage.getTag(), value.substring(0, value.length() > this.channelValueSize ? this.channelValueSize : value.length())});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("exterior send message failed\uff01 " + e.getMessage());
        }
    }
}

