/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.pubsub.redis;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.util.ExecutorProcessPool;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.abilityweb.config.pubsub.ChannelNaming;
import com.ohaotian.abilityweb.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.abilityweb.config.pubsub.redis.PubSubRedisConsumer;
import com.ohaotian.plugin.cache.CacheClient;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPubSub;

@Configuration
public class PubSubRedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PubSubRedisConfiguration.class);
    @Autowired
    private NodeInfoConfig nodeInfo;
    @Autowired
    private WebClusterConfig webClusterConfig;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private PubSubRedisConsumer pubSubRedisConsumer;
    @Autowired
    private PubSubResProperties pubSubResProperties;

    @Bean
    @PostConstruct
    public void exteriorRedisConsumer() {
        log.info("\u7cfb\u7edf\u88c5\u8f7dRedis\u6570\u636e\u6d88\u8d39\u8005\uff1aPubSubRedisConsumer");
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String pushChannel = ChannelNaming.get(PubSubRedisConfiguration.this.pubSubResProperties.getAdmin2web()) + "_" + ChannelNaming.get(PubSubRedisConfiguration.this.webClusterConfig.getName());
                try {
                    PubSubRedisConfiguration.this.cacheClient.subscribe((JedisPubSub)PubSubRedisConfiguration.this.pubSubRedisConsumer, pushChannel);
                }
                catch (Exception e) {
                    throw new Exception("\u5f02\u5e38\u6267\u884cRedis\u8ba2\u9605\u9519\u8bef" + pushChannel + e.getMessage());
                }
            }
        };
        ExecutorProcessPool.getInstance().executeByCustomThread(run);
    }

    @Autowired
    public PubSubRedisConfiguration() {
    }
}

