/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.pubsub.redis;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.system.SystemParam;
import com.ohaotian.abilityweb.component.deploy.SvcDeployHelp;
import com.ohaotian.abilityweb.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityweb.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityweb.mapper.AbilityMapper;
import com.ohaotian.abilityweb.mapper.SystemCodeTypeMapper;
import com.ohaotian.abilityweb.mapper.SystemExtColumnMapper;
import com.ohaotian.abilityweb.service.sync.PluginSyncDataService;
import com.ohaotian.abilityweb.service.sync.SyncDataService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPubSub;

@Service
public class PubSubRedisConsumer
extends JedisPubSub {
    private static final Logger log = LoggerFactory.getLogger(PubSubRedisConsumer.class);
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;
    @Resource
    private SystemCodeTypeMapper systemCodeTypeMapper;
    @Resource
    private SystemExtColumnMapper systemExtColumnMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private PluginSyncDataService pluginSyncDataService;
    @Resource
    NodeInfoConfig nodeInfo;
    @Resource
    SvcDeployHelp svcDeployHelp;
    @Resource
    SyncDataService syncDataService;
    @Resource
    SystemParam systemParam;
    @Resource
    PubSubRes pubSubRes;

    public void init() {
        this.pubSubMsgHandler.setSystemCodeTypeMapper(this.systemCodeTypeMapper);
        this.pubSubMsgHandler.setSystemExtColumnMapper(this.systemExtColumnMapper);
        this.pubSubMsgHandler.setAbilityMapper(this.abilityMapper);
        this.pubSubMsgHandler.setSystemParam(this.systemParam);
        this.pubSubMsgHandler.setPluginSyncDataService(this.pluginSyncDataService);
        this.pubSubMsgHandler.setSyncDataService(this.syncDataService);
        this.pubSubMsgHandler.setNodeInfo(this.nodeInfo);
        this.pubSubMsgHandler.setSvcDeployHelp(this.svcDeployHelp);
        this.pubSubMsgHandler.setPubSubRes(this.pubSubRes);
    }

    public void onMessage(String channel, String message) {
        this.init();
        this.pubSubMsgHandler.redisCoreNodeDeal(message);
    }

    public void onSubscribe(String channel, int subscribedChannels) {
        System.out.printf("subscribe redis channel success, channel %s, subscribedChannels %d%n", channel, subscribedChannels);
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
        System.out.printf("unsubscribe redis channel, channel %s, subscribedChannels %d%n", channel, subscribedChannels);
    }
}

