/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.pubsub.redis;

import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.config.pubsub.ChannelNaming;
import com.ohaotian.abilityweb.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PubSubRedisProvider {
    private static final Logger log = LoggerFactory.getLogger(PubSubRedisProvider.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private PubSubResProperties pubSubResProperties;
    @Value(value="${atp.channel.value.size:200}")
    private int channelValueSize;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    public void provideMessage(String channel, String value) {
        Object master = this.cacheClient.get(this.constantBaseVersion.getMASTER_NAME());
        Map node = GsonUtil.toStringMap((String)master.toString());
        channel = ChannelNaming.get(this.pubSubResProperties.getWeb2admin() + "_" + (String)node.get("name"));
        try {
            log.info("redis\u63a8\u9001\u901a\u9053\uff1a{}", (Object)channel);
            this.cacheClient.publish(channel, value);
        }
        catch (Exception e) {
            log.error("publish channel error,{} --- {}", (Object)channel, (Object)e.getMessage());
        }
    }
}

