/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.handler;

import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.HttpUtil;
import com.ohaotian.abilityweb.component.error.ErrorReturnComponent;
import com.ohaotian.abilityweb.config.init.InitAbilityConfig;
import com.ohaotian.abilityweb.service.esb.EsbService;
import com.ohaotian.abilityweb.util.PrintTLogUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Component
public class JsonHandler {
    @Resource
    private EsbService esbService;
    @Resource(name="currentCount")
    AtomicInteger currentCount;
    @Resource
    ErrorReturnComponent errorReturnComponent;

    public Mono<ServerResponse> doAbility(ServerRequest serverRequest) {
        MsgContext msgContext = new MsgContext();
        if (!InitAbilityConfig.getIsFinished().booleanValue()) {
            HashMap<String, String> result = new HashMap<String, String>(8);
            result.put("rspCode", "9999");
            result.put("rspDesc", "\u8bf7\u6c42\u5931\u8d25\uff01\u8bf7\u7b49\u5f85\u80fd\u529b\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u80fd\u529b\u5e73\u53f0\u542f\u52a8\u4e2d...");
            return ServerResponse.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).contentType(MediaType.APPLICATION_JSON_UTF8).body((Publisher)Mono.just(result), Map.class);
        }
        Mono result = this.esbService.doService(serverRequest, msgContext).flatMap(s -> {
            PrintTLogUtil.printRequestOutLog(msgContext);
            HttpUtil.setContentType((MsgContext)msgContext, (String)"application/json;charset=UTF-8");
            return ((ServerResponse.BodyBuilder)ServerResponse.ok().headers(httpHeaders -> msgContext.getSelfDefHeader().getSelfDefRspMap().forEach((k, v) -> httpHeaders.add(k, v)))).syncBody(s);
        }).doOnCancel(() -> this.currentCount.getAndDecrement()).onErrorResume(e -> this.errorReturnComponent.doErrorReturn((Throwable)e, msgContext, MediaType.APPLICATION_JSON_UTF8, "json"));
        return result;
    }

    public Mono<ServerResponse> doGetAbility(ServerRequest serverRequest) {
        serverRequest.exchange().getRequest().mutate().header("Content-Type", new String[]{"application/json"});
        return this.doAbility(serverRequest);
    }
}

