/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.handler;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.oauth2.Oauth2Config;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.ResultData;
import com.ohaotian.abilitycommon.util.MD5Util;
import com.ohaotian.abilityweb.config.init.InitAbilityConfig;
import com.ohaotian.abilityweb.mapper.AppSecretMapper;
import com.ohaotian.abilityweb.model.po.AppSecretPO;
import com.ohaotian.plugin.cache.CacheClient;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Component
public class Oauth2Handler {
    private static Logger logger = LogManager.getLogger(Oauth2Handler.class);
    private static final String DATE_FORMATE = "yyyy-MM-dd HH:mm:ss";
    @Resource
    private CacheClient cacheClient;
    @Resource
    private NodeInfoConfig nodeInfo;
    @Resource
    private AppSecretMapper appSecretMapper;
    @Resource
    private Oauth2Config oauth2Config;

    public Mono<ServerResponse> doService(ServerRequest serverRequest) {
        if (!InitAbilityConfig.getIsFinished().booleanValue()) {
            HashMap<String, String> result = new HashMap<String, String>(8);
            result.put("rspCode", "9999");
            result.put("rspDesc", "\u8bf7\u6c42\u5931\u8d25\uff01\u8bf7\u7b49\u5f85\u80fd\u529b\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u80fd\u529b\u5e73\u53f0\u542f\u52a8\u4e2d...");
            return ServerResponse.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).contentType(MediaType.APPLICATION_JSON_UTF8).syncBody(result);
        }
        if (serverRequest.method().matches("POST")) {
            return Mono.just((Object)this.getOauth(serverRequest)).flatMap(map -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON_UTF8).syncBody(map).onErrorResume(e -> {
                logger.error(e.getMessage());
                ResultData resultData_ = ResultData.error((CodeMsg)CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{e.getMessage()}));
                return ServerResponse.badRequest().contentType(MediaType.APPLICATION_JSON_UTF8).syncBody((Object)resultData_);
            }));
        }
        return ServerResponse.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).contentType(MediaType.APPLICATION_JSON_UTF8).syncBody((Object)CodeMsg.ESB_REQUEST_ERROR);
    }

    private Map getOauth(ServerRequest serverRequest) {
        try {
            String sign;
            String timestamp;
            String password;
            String userName;
            HttpHeaders httpHeaders = serverRequest.headers().asHttpHeaders();
            Iterator iterator = httpHeaders.entrySet().iterator();
            ConcurrentHashMap headersMap = new ConcurrentHashMap();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                headersMap.put(next.getKey(), ((List)next.getValue()).get(0));
            }
            MultiValueMap queryParams = serverRequest.exchange().getRequest().getQueryParams();
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)headersMap.get("username")))) {
                userName = (String)headersMap.get("username");
                password = (String)headersMap.get("password");
                timestamp = (String)headersMap.get("timestamp");
                sign = (String)headersMap.get("sign");
            } else if (queryParams.get((Object)"username") != null && ((List)queryParams.get((Object)"username")).size() > 0) {
                userName = (String)((List)queryParams.get((Object)"username")).get(0);
                timestamp = queryParams.get((Object)"timestamp") != null ? (String)((List)queryParams.get((Object)"timestamp")).get(0) : null;
                password = queryParams.get((Object)"password") != null ? (String)((List)queryParams.get((Object)"password")).get(0) : null;
                sign = queryParams.get((Object)"sign") != null ? (String)((List)queryParams.get((Object)"sign")).get(0) : null;
            } else {
                throw new AbilityException(":Oauth2Plugin >>> \u672a\u627e\u5230\u6709\u6548\u6807\u793a\uff1ausername");
            }
            if (StringUtils.isEmpty((CharSequence)timestamp)) {
                throw new AbilityException(":Oauth2Plugin >>> \u672a\u627e\u5230\u6709\u6548\u6807\u793a\uff1atimestamp");
            }
            if (StringUtils.isEmpty((CharSequence)password)) {
                throw new AbilityException(":Oauth2Plugin >>> \u672a\u627e\u5230\u6709\u6548\u6807\u793a\uff1apassword");
            }
            if (StringUtils.isEmpty((CharSequence)sign)) {
                throw new AbilityException(":Oauth2Plugin >>> \u672a\u627e\u5230\u6709\u6548\u6807\u793a\uff1asign");
            }
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_FORMATE);
                LocalDateTime time = LocalDateTime.parse(timestamp, dateTimeFormatter);
                LocalDateTime now = LocalDateTime.now();
                Duration duration = Duration.between(now, time);
                long nanos = duration.toMillis();
                if (this.oauth2Config.isValidTimeFlag() && this.oauth2Config.getValidTime() < Math.abs(nanos)) {
                    logger.info("Token\u6821\u9a8c\u672a\u901a\u8fc7-\u65f6\u95f4\u4e0d\u5408\u6cd5:timestamp" + timestamp);
                    throw new AbilityException(":Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-timestamp\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\uff1a" + timestamp);
                }
            }
            catch (DateTimeParseException e) {
                throw new AbilityException(":Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-timestamp\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u683c\u5f0f\u4e3a2014-01-01 01:01:01");
            }
            String appCode = userName;
            AppSecretPO appSecretPO = this.appSecretMapper.selectByAppCode(appCode, this.nodeInfo.getClusterId());
            if (appSecretPO == null || StringUtils.isEmpty((CharSequence)appSecretPO.getAppSecret())) {
                throw new AbilityException(":Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-appCode:[" + appCode + "]\u65e0\u6743\u9650");
            }
            if (!password.equalsIgnoreCase(appSecretPO.getAppSecret())) {
                throw new AbilityException(":Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-\u5bc6\u7801\u9519\u8bef");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(userName).append(password).append(timestamp).append(password);
            String token = MD5Util.sign((String)stringBuffer.toString()).toLowerCase();
            if (!sign.equals(token)) {
                logger.info("Token\u6821\u9a8c\u672a\u901a\u8fc7-token\u4e0d\u5408\u6cd5:sign" + sign);
                throw new AbilityException(":Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-token\u4e0d\u5408\u6cd5");
            }
            String key = this.nodeInfo.getClusterId() + "|" + appCode;
            String accessKey = key + "|" + "accessToken";
            boolean aBoolean = ObjectUtils.isEmpty((Object)this.cacheClient.get(accessKey));
            String accessToken = UUID.randomUUID().toString();
            if (aBoolean) {
                String oldAccessKey = this.cacheClient.get(accessKey).toString();
                this.cacheClient.delete(accessKey);
                this.cacheClient.delete(oldAccessKey);
                this.cacheClient.set(accessKey, (Object)accessToken);
                this.cacheClient.expire(accessKey, Math.toIntExact(this.oauth2Config.getAccessTokenValidity()));
                this.cacheClient.set(accessToken, (Object)appCode);
                this.cacheClient.expire(accessToken, Math.toIntExact(this.oauth2Config.getAccessTokenValidity()));
            } else {
                this.cacheClient.set(accessKey, (Object)accessToken);
                this.cacheClient.expire(accessKey, Math.toIntExact(this.oauth2Config.getAccessTokenValidity()));
                this.cacheClient.set(accessToken, (Object)appCode);
                this.cacheClient.expire(accessToken, Math.toIntExact(this.oauth2Config.getAccessTokenValidity()));
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMATE);
            long expiresAt = System.currentTimeMillis() + this.cacheClient.getExpireTimeByKey(accessKey) * 1000L;
            String format = simpleDateFormat.format(new Date(expiresAt));
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("success", true);
            result.put("access_token", accessToken);
            result.put("expires_at", format);
            return result;
        }
        catch (DateTimeParseException e) {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("success", false);
            result.put("msg", "oauth2\u6821\u9a8c\u672a\u901a\u8fc7-timestamp\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u683c\u5f0f\u4e3a2014-01-01 01:01:01");
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("success", false);
            result.put("msg", e.getMessage());
            return result;
        }
    }
}

