/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.balance.spi;

import com.ohaotian.abilitycommon.enums.LoadBalanceEnum;
import com.ohaotian.abilitycommon.model.bo.RegionAddrBO;
import com.ohaotian.abilityweb.service.balance.LoadBalance;
import com.ohaotian.abilityweb.util.AtomicPositiveInteger;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RoundRobinLoadBalance
implements LoadBalance {
    private final ConcurrentMap<String, AtomicPositiveInteger> sequences = new ConcurrentHashMap<String, AtomicPositiveInteger>();

    @Override
    public RegionAddrBO select(List<RegionAddrBO> upstreamList) {
        if (upstreamList.size() == 1) {
            return upstreamList.get(0);
        }
        RegionAddrBO regionAddrPO = upstreamList.get(0);
        String key = String.join((CharSequence)":", regionAddrPO.getIp(), regionAddrPO.getPort());
        int length = upstreamList.size();
        AtomicPositiveInteger sequence = (AtomicPositiveInteger)this.sequences.get(key);
        if (sequence == null) {
            this.sequences.putIfAbsent(key, new AtomicPositiveInteger());
            sequence = (AtomicPositiveInteger)this.sequences.get(key);
        }
        return upstreamList.get(sequence.getAndIncrement() % length);
    }

    @Override
    public String algorithm() {
        return LoadBalanceEnum.ROUND_ROBIN.getName();
    }
}

