/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.check.hpaty.impl;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilityweb.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityweb.mapper.AppMapper;
import com.ohaotian.abilityweb.mapper.RegionMapper;
import com.ohaotian.abilityweb.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityweb.model.po.AppPO;
import com.ohaotian.abilityweb.service.check.hpaty.HpatyCheckService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HpatyCheckServiceImpl
implements HpatyCheckService {
    private static Logger logger = LogManager.getLogger(HpatyCheckServiceImpl.class);
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    RegionMapper regionMapper;
    @Resource
    AppMapper appMapper;
    @Resource
    NodeInfoConfig nodeInfo;

    @Override
    public void doHpatyCheck(MsgContext msgContext) {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
        abilityProvideDeployPO.setAbilityId(esbAbility.getAbilityId());
        List<AbilityProvideDeployPO> pos = this.abilityProvideDeployMapper.queryByCond(abilityProvideDeployPO);
        if (CollectionUtils.isEmpty(pos)) {
            throw new AbilityException(CodeMsg.E_SVC_NO_HREGION_DEPLOYED);
        }
        AppPO appPO = this.appMapper.queryByAppId(pos.get(0).getAppId());
        if (appPO.getAttendStatus() != 1) {
            throw new AbilityException(CodeMsg.E_HPARTY_NOT_SIGN_IN);
        }
        List<Long> ids = pos.stream().map(po -> po.getRegionId()).collect(Collectors.toList());
        List<RegionBO> regions = this.regionMapper.queryByRegionIds(ids);
        Optional<RegionBO> firstRegionPO = regions.stream().filter(po -> po.getRegionType() == 0).findFirst();
        if (!firstRegionPO.isPresent()) {
            throw new AbilityException(CodeMsg.E_HREGION_NO_USED);
        }
        RegionBO regionBO = firstRegionPO.get();
        if (regionBO.getAttendStatus() != 1) {
            throw new AbilityException(CodeMsg.E_HREGION_SIGN_OUT);
        }
        msgContext.getSelfDefHeader().setRegionBO(regionBO);
    }
}

