/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.check.message.impl;

import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilityweb.model.po.AbilityParamPO;
import com.ohaotian.abilityweb.service.check.message.MessgeService;
import com.ohaotian.abilityweb.util.JsonShemaValidator;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonMessgeService
implements MessgeService {
    private static Logger logger = LogManager.getLogger(JsonMessgeService.class);

    @Override
    public void validReqMessage(MsgContext msgContext) throws AbilityException {
        try {
            String req = new String(msgContext.getTlogReqHeader().getReqData(), "UTF-8");
            if (!req.startsWith("{")) {
                throw new AbilityException(CodeMsg.E_REQ_VALID_REQ_ERROR.fillArgs(new Object[]{"\u62a5\u6587\uff1a##" + req + "##\uff0c\u9519\u8bef\u4fe1\u606f\uff1a\u62a5\u6587\u534f\u8bae\u975ejson\u6570\u636e"}));
            }
            ProcessingReport processingMessages = JsonShemaValidator.validatorSchema(msgContext.getEsbAbility().getJsonInputSchema(), req);
            if (!processingMessages.isSuccess()) {
                throw new AbilityException(CodeMsg.E_REQ_VALID_REQ_ERROR.fillArgs(new Object[]{"\u62a5\u6587\uff1a##" + req + "##\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + processingMessages.toString()}));
            }
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u62a5\u6587\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_REQ_VALID_REQ_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    @Override
    public void validRspMessage(MsgContext msgContext) throws AbilityException {
        try {
            String rspText = new String(msgContext.getTlogRspHeader().getRspData(), Consts.UTF_8);
            if (rspText == null || StringUtils.isBlank((CharSequence)rspText)) {
                throw new AbilityException(CodeMsg.E_REQ_VALID_RSP_ERROR.fillArgs(new Object[]{"\u843d\u5730\u8282\u70b9\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a"}));
            }
            if (!rspText.startsWith("{")) {
                throw new AbilityException(CodeMsg.E_REQ_VALID_REQ_ERROR.fillArgs(new Object[]{"\u62a5\u6587\uff1a##" + rspText + "##\uff0c\u9519\u8bef\u4fe1\u606f\uff1a\u62a5\u6587\u534f\u8bae\u975ejson\u6570\u636e"}));
            }
            ProcessingReport processingMessages = JsonShemaValidator.validatorSchema(msgContext.getEsbAbility().getJsonOutputSchema(), rspText);
            if (!processingMessages.isSuccess()) {
                throw new AbilityException(CodeMsg.E_REQ_VALID_RSP_ERROR.fillArgs(new Object[]{"\u62a5\u6587\uff1a##" + rspText + "##\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + processingMessages.toString()}));
            }
        }
        catch (Exception e) {
            logger.error("\u54cd\u5e94\u62a5\u6587\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_REQ_VALID_RSP_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    @Override
    public void checkDataEqualsOut(MsgContext msgContext) {
        if (Constants.OutTypeList.jsonList.contains(msgContext.getEsbAbility().getOutputProtocal())) {
            msgContext.setUniformityFlag(Boolean.valueOf(true));
        }
    }

    @Override
    public String getMockMsg(MsgContext msgContext, AbilityParamPO abilityParamPO) {
        TlogRspHeader tlogRspHeader = new TlogRspHeader();
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("Content-Type", "application/json");
        tlogRspHeader.setHeaders(map);
        msgContext.setTlogRspHeader(tlogRspHeader);
        return abilityParamPO.getRspJsonTemplate();
    }

    @Override
    public String getcontentType() {
        return "application/json";
    }
}

