/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.check.subscribe.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.AppExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.abilityweb.mapper.AppExtColumnMapper;
import com.ohaotian.abilityweb.mapper.AppMapper;
import com.ohaotian.abilityweb.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityweb.model.po.AppExtColumnPO;
import com.ohaotian.abilityweb.model.po.AppPO;
import com.ohaotian.abilityweb.model.po.AppSubscribeDeployPO;
import com.ohaotian.abilityweb.service.check.subscribe.SubscribeCheckService;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="tokenCheck")
public class SubscribeCheckServiceImpl
implements SubscribeCheckService {
    private static Logger logger = LogManager.getLogger(SubscribeCheckServiceImpl.class);
    @Resource
    private AppMapper appMapper;
    @Resource
    private AppExtColumnMapper appExtColumnMapper;
    @Resource
    private AppSubscribeDeployMapper appSubscribeDeployMapper;

    @Override
    public void doSubscribeCheckFromHeader(MsgContext msgContext) throws AbilityException {
        Map headersMap;
        String appCode;
        EsbAbility esbAbility = msgContext.getEsbAbility();
        if (esbAbility.getAppCodeSource() == 0 && !this.check(appCode = (String)(headersMap = msgContext.getTlogReqHeader().getHeadersMap()).get("appCode"), msgContext)) {
            throw new AbilityException(CodeMsg.E_OPARTY_NOT_EXIST);
        }
    }

    @Override
    public void doSubscribeCheckFromBody(MsgContext msgContext) throws AbilityException {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        if (esbAbility.getAppCodeSource() == 1) {
            Object reqObj = msgContext.getTlogReqHeader().getReqObj(msgContext);
            String appCode = null;
            try {
                appCode = ReflectBeanValueUtil.getValue((Object)reqObj, (String)esbAbility.getAppCodePath()).toString();
            }
            catch (Exception e) {
                logger.error("\u4ecebody\u62a5\u6587\u4f53\u4e2d\u83b7\u53d6appCode\u5f02\u5e38:" + e);
                throw new AbilityException(CodeMsg.E_REQ_BODY_VALID);
            }
            if (!this.check(appCode, msgContext)) {
                throw new AbilityException(CodeMsg.E_OPARTY_NOT_EXIST);
            }
        }
    }

    private boolean check(String appCode, MsgContext msgContext) {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            throw new AbilityException(CodeMsg.E_REQ_HEAD_VALID);
        }
        AppPO appPO1 = new AppPO();
        appPO1.setAppCode(appCode);
        AppPO appPO = this.appMapper.queryLimitOne(appPO1);
        if (Objects.isNull(appPO)) {
            throw new AbilityException(CodeMsg.E_OPARTY_NOT_EXIST);
        }
        if (appPO.getAttendStatus() != 1) {
            throw new AbilityException(CodeMsg.E_PARTY_NOT_SIGN_NORMAL);
        }
        AppSubscribeDeployPO appSubscribeDeployPO = new AppSubscribeDeployPO();
        appSubscribeDeployPO.setAppId(appPO.getAppId());
        appSubscribeDeployPO.setAbilityId(esbAbility.getAbilityId());
        AppSubscribeDeployPO appSubscribeDeployPO1 = this.appSubscribeDeployMapper.queryLimitOne(appSubscribeDeployPO);
        AppExtColumnPO appExtColumnPO = this.appExtColumnMapper.queryLimitOneByAppId(appPO.getAppId());
        if (appSubscribeDeployPO1 != null) {
            AppBO appBO = new AppBO();
            if (appPO.getAppId() != null) {
                appBO.setAppId(appPO.getAppId());
            }
            if (!StringUtils.isEmpty((CharSequence)appPO.getAppCode())) {
                appBO.setAppCode(appPO.getAppCode());
            }
            if (!StringUtils.isEmpty((CharSequence)appPO.getAppName())) {
                appBO.setAppName(appPO.getAppName());
            }
            if (appPO.getAttendStatus() != null) {
                appBO.setAttendStatus(appPO.getAttendStatus());
            }
            if (appPO.getHirerId() != null) {
                appBO.setHirerId(appPO.getHirerId());
            }
            if (appPO.getIsProvider() != null) {
                appBO.setIsProvider(appPO.getIsProvider());
            }
            AppExtColumnBO appExtColumnBO = new AppExtColumnBO();
            if (appExtColumnPO.getAppId() != null) {
                appExtColumnBO.setAppId(appExtColumnPO.getAppId());
            }
            if (!StringUtils.isEmpty((CharSequence)appExtColumnPO.getAppOne())) {
                appExtColumnBO.setAppOne(appExtColumnPO.getAppOne());
            }
            if (!StringUtils.isEmpty((CharSequence)appExtColumnPO.getAppTwo())) {
                appExtColumnBO.setAppTwo(appExtColumnPO.getAppTwo());
            }
            if (!StringUtils.isEmpty((CharSequence)appExtColumnPO.getAppThree())) {
                appExtColumnBO.setAppThree(appExtColumnPO.getAppThree());
            }
            if (!StringUtils.isEmpty((CharSequence)appExtColumnPO.getAppFour())) {
                appExtColumnBO.setAppFour(appExtColumnPO.getAppFour());
            }
            if (!StringUtils.isEmpty((CharSequence)appExtColumnPO.getAppFive())) {
                appExtColumnBO.setAppFive(appExtColumnPO.getAppFive());
            }
            msgContext.getSelfDefHeader().setApp(appBO);
            msgContext.getSelfDefHeader().setAppExtColumn(appExtColumnBO);
            return true;
        }
        AppBO provideApp = msgContext.getEsbAbility().getProviderApp();
        if (appCode.equals(provideApp.getAppCode())) {
            msgContext.getSelfDefHeader().setApp(provideApp);
            msgContext.getSelfDefHeader().setAppExtColumn(msgContext.getEsbAbility().getProviderAppColumn());
            return true;
        }
        return false;
    }
}

