/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.client;

import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.model.bo.RegionAddrBO;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilityweb.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityweb.model.po.AbilityProvideHttpCustomPO;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CallInterfaceHandler {
    public static String getUrl(MsgContext msgContext, AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper) {
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        Map selfDefMap = selfDefHeader.getSelfDefMap();
        RegionAddrBO regionAddrBO = selfDefHeader.getRegionAddrBO();
        StringBuilder regionAddrUrl = new StringBuilder();
        if (Constants.Http.HTTPS_INT.equals(regionBO.getCallProtocol())) {
            regionAddrUrl.append("https");
        } else {
            regionAddrUrl.append("http");
        }
        regionAddrUrl.append(":").append("//").append(regionAddrBO.getIp());
        if (StringUtils.isNotEmpty((CharSequence)regionAddrBO.getPort())) {
            regionAddrUrl.append(":").append(regionAddrBO.getPort());
        }
        String eprPath = null;
        if (!Objects.isNull(selfDefMap) && selfDefMap.containsKey("eprPath") && StringUtils.isNotEmpty((CharSequence)(eprPath = (String)selfDefMap.get("eprPath")))) {
            regionAddrUrl.append(com.ohaotian.abilitycommon.util.StringUtils.dealPath((String)msgContext.getUrlParams(), (String)eprPath));
        }
        if (StringUtils.isEmpty(eprPath)) {
            AbilityProvideHttpCustomPO abilityProvideHttpCustomPo = new AbilityProvideHttpCustomPO();
            abilityProvideHttpCustomPo.setAbilityId(esbAbility.getAbilityId());
            abilityProvideHttpCustomPo.setRegionId(regionBO.getRegionId());
            abilityProvideHttpCustomPo = abilityProvideHttpCustomMapper.queryLimitOne(abilityProvideHttpCustomPo);
            msgContext.setMqId(abilityProvideHttpCustomPo.getMqId());
            eprPath = abilityProvideHttpCustomPo.getEprPath();
            regionAddrUrl.append(com.ohaotian.abilitycommon.util.StringUtils.dealPath((String)msgContext.getUrlParams(), (String)eprPath));
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)selfDefHeader.getSelfDefMap().get("addr-expand")))) {
            regionAddrUrl.append((String)selfDefHeader.getSelfDefMap().get("addr-expand"));
            selfDefHeader.getSelfDefMap().remove("addr-expand");
        }
        return regionAddrUrl.toString();
    }
}

