/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.client.http.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilitycommon.util.Base64Utils;
import com.ohaotian.abilityweb.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityweb.mapper.RegionCertificateMapper;
import com.ohaotian.abilityweb.model.po.RegionCertificatePO;
import com.ohaotian.abilityweb.service.client.CallInterfaceHandler;
import com.ohaotian.abilityweb.service.client.http.HttpClientProtocolRouteService;
import com.ohaotian.abilityweb.service.client.http.HttpClientStaticFactory;
import com.ohaotian.abilityweb.util.PrintTLogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component(value="nomalHttpClient")
public class HttpClientProtocolRouteServiceImpl
implements HttpClientProtocolRouteService {
    private static final Logger log = LoggerFactory.getLogger(HttpClientProtocolRouteServiceImpl.class);
    @Resource
    RegionCertificateMapper regionCertificateMapper;
    @Resource
    private AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper;

    @Override
    public Mono<MsgContext> send(MsgContext msgContext) throws AbilityException {
        return Mono.just((Object)this.sendMsCxt(msgContext));
    }

    @Override
    public MsgContext sendMsCxt(MsgContext msgContext) throws AbilityException {
        TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        Map overtimeMap = esbAbility.getOvertime();
        Map retryTimeMap = esbAbility.getRetryTime();
        Integer overtime = (Integer)overtimeMap.get(regionBO.getRegionId()) * 1000;
        Integer retryTime = (Integer)retryTimeMap.get(regionBO.getRegionId());
        String outputTransProtocal = esbAbility.getOutputTransProtocal();
        TlogRspHeader tlogRspHeader = new TlogRspHeader();
        String url = CallInterfaceHandler.getUrl(msgContext, this.abilityProvideHttpCustomMapper);
        selfDefHeader.setUrl(url);
        String jsonStr = new String(tlogReqHeader.getReqData(), Consts.UTF_8);
        PrintTLogUtil.printRespondInLog(msgContext);
        do {
            try {
                CloseableHttpClient httpClient = this.getHttpClient(regionBO);
                MyHttpResult myHttpResult = "GET".equalsIgnoreCase(outputTransProtocal) ? this.doGet(httpClient, url, msgContext.getSelfDefHeader().getSelfDefMap(), msgContext.getTlogReqHeader().getReqObj(msgContext), jsonStr, overtime) : (((String)msgContext.getSelfDefHeader().getSelfDefMap().get("Content-Type")).startsWith("application/x-www-form-urlencoded") ? this.doPostForm(httpClient, url, msgContext.getSelfDefHeader().getSelfDefMap(), jsonStr, overtime) : this.doPost(httpClient, url, msgContext.getSelfDefHeader().getSelfDefMap(), jsonStr, overtime));
                if (myHttpResult.getResStatusCode() == 200) {
                    tlogRspHeader.setHeaders(myHttpResult.getHeadersMap());
                    tlogRspHeader.setRspData(myHttpResult.getResString().getBytes(Consts.UTF_8));
                    msgContext.setTlogRspHeader(tlogRspHeader);
                    PrintTLogUtil.printRespondOutLog(msgContext);
                    return msgContext;
                }
                log.error("httpClient-error:{},body:{}", (Object)myHttpResult.getResStatusCode(), (Object)myHttpResult.getResString());
                if (retryTime - 1 < 0) {
                    throw new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":" + myHttpResult.getResStatusCode() + ":" + myHttpResult.getResString()}));
                }
            }
            catch (AbilityException e) {
                log.error("\u843d\u5730\u8c03\u7528\u5f02\u5e38", (Throwable)e);
                if (retryTime - 1 >= 0) continue;
                throw e;
            }
            catch (Throwable e) {
                log.error("\u843d\u5730\u8c03\u7528\u5f02\u5e38", e);
                if (retryTime - 1 >= 0) continue;
                throw new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":" + e.getMessage()}), e);
            }
        } while ((retryTime = Integer.valueOf(retryTime - 1)) >= 0);
        return null;
    }

    private CloseableHttpClient getHttpClient(RegionBO regionBO) throws Exception {
        if (regionBO.getCallProtocol().equals(Constants.Http.HTTP_INT)) {
            return HttpClientStaticFactory.getHttpClient();
        }
        if (regionBO.getTrustAllCertificate().equals(Constants.TrustManager.TRUSTALL)) {
            if (regionBO.getCallAuthenticate().equals(Constants.HttpAuthenticate.SINGLE)) {
                return HttpClientStaticFactory.getHttpClientAndTrustAll();
            }
            RegionCertificatePO regionCertificatePO = this.regionCertificateMapper.queryByRegionId(regionBO.getRegionId());
            ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getCertificate()));
            return HttpClientStaticFactory.getHttpClientWithCertificateAndTrustAll(certificateInputStream, regionCertificatePO.getCerKeypass());
        }
        RegionCertificatePO regionCertificatePO = this.regionCertificateMapper.queryByRegionId(regionBO.getRegionId());
        if (regionBO.getCallAuthenticate().equals(Constants.HttpAuthenticate.SINGLE)) {
            if (regionCertificatePO == null || regionCertificatePO.getTrustKeystore() == null) {
                return HttpClientStaticFactory.getHttpClient();
            }
            ByteArrayInputStream trustKeystoreInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getTrustKeystore()));
            return HttpClientStaticFactory.getHttpClientWithTrustStore(trustKeystoreInputStream, regionCertificatePO.getTrustKeystoreKeypass());
        }
        if (regionCertificatePO.getTrustKeystore() == null) {
            ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getCertificate()));
            return HttpClientStaticFactory.getHttpClientWithCertificateBySecurity(certificateInputStream, regionCertificatePO.getCerKeypass());
        }
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getCertificate()));
        ByteArrayInputStream trustKeystoreInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getTrustKeystore()));
        return HttpClientStaticFactory.getHttpClient(certificateInputStream, regionCertificatePO.getCerKeypass(), trustKeystoreInputStream, regionCertificatePO.getTrustKeystoreKeypass());
    }

    private MyHttpResult doPost(CloseableHttpClient httpClient, String url, Map<String, String> myHeader, String jsonStr, Integer overtime) throws IOException {
        log.info("POST---HttpClient---\u843d\u5730\u5730\u5740: {}", (Object)url);
        log.info("POST---HttpClient---\u843d\u5730\u62a5\u6587\uff1a{}", (Object)jsonStr);
        log.info("POST---HttpClient---\u8bf7\u6c42\u5934\uff1a{}", myHeader);
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url.trim());
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(overtime.intValue()).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonStr, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            if (myHeader != null) {
                myHeader.forEach((k, v) -> httpPost.setHeader(k, v));
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            MyHttpResult myHttpResult = new MyHttpResult();
            myHttpResult.setResStatusCode(response.getStatusLine().getStatusCode());
            myHttpResult.setResString(EntityUtils.toString(response.getEntity(), Consts.UTF_8));
            HashMap headersMap = new HashMap();
            Arrays.asList(response.getAllHeaders()).stream().forEach(h -> headersMap.put(h.getName(), h.getValue()));
            myHttpResult.setHeadersMap(headersMap);
            MyHttpResult myHttpResult2 = myHttpResult;
            return myHttpResult2;
        }
        catch (Exception e) {
            throw new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyHttpResult doGet(CloseableHttpClient httpClient, String url, Map<String, String> myHeader, Object object, String jsonStr, Integer overtime) throws URISyntaxException, IOException, IllegalAccessException {
        CloseableHttpResponse response = null;
        Map mapType = (Map)JSON.parseObject((String)jsonStr, Map.class);
        log.info("GET---HttpClient---\u8f6c\u6362\u524d\u62a5\u6587: object-->{}", object);
        log.info("GET---HttpClient---\u8f6c\u6362\u524d\u62a5\u6587: jsonStr-->{}", (Object)jsonStr);
        log.info("GET---HttpClient---\u8f6c\u6362\u524d\u62a5\u6587: mapType-->{}", (Object)mapType);
        try {
            URI uri;
            try {
                URIBuilder uriBuilder = new URIBuilder(url);
                if (object != null) {
                    JSONObject map = JSON.parseObject((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
                    for (Map.Entry entry : map.entrySet()) {
                        uriBuilder.setParameter(entry.getKey().toString(), String.valueOf(entry.getValue()));
                    }
                }
                uri = uriBuilder.build();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new AbilityException("Get\u843d\u5730\u62a5\u6587\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
            }
            HttpGet httpGet = new HttpGet(uri);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(overtime.intValue()).setRedirectsEnabled(true).build();
            httpGet.setConfig(requestConfig);
            if (myHeader != null) {
                myHeader.forEach((k, v) -> httpGet.setHeader(k, v));
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
            MyHttpResult myHttpResult = new MyHttpResult();
            myHttpResult.setResStatusCode(response.getStatusLine().getStatusCode());
            myHttpResult.setResString(EntityUtils.toString(response.getEntity(), Consts.UTF_8));
            HashMap headersMap = new HashMap();
            Arrays.asList(response.getAllHeaders()).stream().forEach(h -> headersMap.put(h.getName(), h.getValue()));
            myHttpResult.setHeadersMap(headersMap);
            log.info("GET---HttpClient---\u843d\u5730\u5730\u5740: {}", (Object)uri);
            log.info("GET---HttpClient---\u8bf7\u6c42\u5934\uff1a{}", myHeader);
            MyHttpResult myHttpResult2 = myHttpResult;
            return myHttpResult2;
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyHttpResult doPostForm(CloseableHttpClient httpClient, String url, Map<String, String> myHeader, String jsonStr, Integer overtime) throws IOException {
        log.info("POST-FORM--HttpClient---\u843d\u5730\u5730\u5740: {}", (Object)url);
        log.info("POST-FORM--HttpClient---\u8bf7\u6c42\u5934\uff1a{}", myHeader);
        CloseableHttpResponse resp = null;
        try {
            Map params = (Map)JSON.parseObject((String)jsonStr, Map.class);
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(overtime.intValue()).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry entry : params.entrySet()) {
                    list.add(new BasicNameValuePair((String)entry.getKey(), String.valueOf(entry.getValue())));
                }
                log.info("POST-FORM--HttpClient---\u843d\u5730\u62a5\u6587\uff1a{}", list);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, StandardCharsets.UTF_8));
            }
            resp = httpClient.execute((HttpUriRequest)httpPost);
            String body = EntityUtils.toString(resp.getEntity(), StandardCharsets.UTF_8);
            int statusCode = resp.getStatusLine().getStatusCode();
            MyHttpResult myHttpResult = new MyHttpResult();
            myHttpResult.setResStatusCode(statusCode);
            myHttpResult.setResString(body);
            HashMap headersMap = new HashMap();
            Arrays.stream(resp.getAllHeaders()).forEach(h -> headersMap.put(h.getName(), h.getValue()));
            myHttpResult.setHeadersMap(headersMap);
            MyHttpResult myHttpResult2 = myHttpResult;
            return myHttpResult2;
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
            if (resp != null) {
                resp.close();
            }
        }
    }

    public static class MyHttpResult {
        private Integer resStatusCode;
        private Map headersMap;
        private String resString;

        public Integer getResStatusCode() {
            return this.resStatusCode;
        }

        public void setResStatusCode(Integer resStatusCode) {
            this.resStatusCode = resStatusCode;
        }

        public Map getHeadersMap() {
            return this.headersMap;
        }

        public void setHeadersMap(Map headersMap) {
            this.headersMap = headersMap;
        }

        public String getResString() {
            return this.resString;
        }

        public void setResString(String resString) {
            this.resString = resString;
        }
    }
}

