/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.client.push.kafka.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityweb.service.client.CallInterfaceHandler;
import com.ohaotian.abilityweb.service.client.http.HttpClientProtocolRouteService;
import com.ohaotian.abilityweb.service.client.push.PushClientProtocolRouteService;
import com.ohaotian.abilityweb.service.client.push.model.bo.KafkaSendReqBo;
import com.ohaotian.abilityweb.service.client.webclient.WebClientProtocolRouteService;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service(value="KafkaPushClient")
public class KafkaPushClientProtocolRouteServiceImpl
implements PushClientProtocolRouteService {
    private static final Logger log = LoggerFactory.getLogger(KafkaPushClientProtocolRouteServiceImpl.class);
    @Qualifier(value="nomalWebClient")
    @Autowired
    private WebClientProtocolRouteService webClientProtocolRouteService;
    @Qualifier(value="nomalHttpClient")
    @Autowired
    private HttpClientProtocolRouteService httpClientProtocolRouteService;
    @Resource
    private AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper;

    @Override
    public Mono<MsgContext> send(MsgContext msgContext) throws AbilityException {
        this.encapsulation(msgContext);
        return this.webClientProtocolRouteService.send(msgContext);
    }

    @Override
    public MsgContext sendMsCxt(MsgContext msgContext) throws AbilityException {
        this.encapsulation(msgContext);
        return this.httpClientProtocolRouteService.sendMsCxt(msgContext);
    }

    private void encapsulation(MsgContext msgContext) {
        CallInterfaceHandler.getUrl(msgContext, this.abilityProvideHttpCustomMapper);
        String jsonStr = new String(msgContext.getTlogReqHeader().getReqData(), Consts.UTF_8);
        if (msgContext.getSecurityInfo().isEncryptBody() == Boolean.TRUE.booleanValue()) {
            jsonStr = new String(Base64.encodeBase64((byte[])msgContext.getTlogReqHeader().getReqData()));
        }
        KafkaSendReqBo kafkaSendReqBo = new KafkaSendReqBo();
        kafkaSendReqBo.setMqId(msgContext.getMqId());
        kafkaSendReqBo.setData(jsonStr);
        msgContext.getTlogReqHeader().setReqData(GsonUtil.toJson((Object)kafkaSendReqBo).getBytes(StandardCharsets.UTF_8));
    }
}

