/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.client.webclient.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilitycommon.util.Base64Utils;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityweb.mapper.RegionCertificateMapper;
import com.ohaotian.abilityweb.model.po.RegionCertificatePO;
import com.ohaotian.abilityweb.service.client.CallInterfaceHandler;
import com.ohaotian.abilityweb.service.client.webclient.WebClientProtocolRouteService;
import com.ohaotian.abilityweb.service.client.webclient.WebClientStaticFactory;
import com.ohaotian.abilityweb.util.FileUtils;
import com.ohaotian.abilityweb.util.PrintTLogUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;

@Service(value="nomalWebClient")
public class WebClientProtocolRouteServiceImpl
implements WebClientProtocolRouteService {
    private static final Logger log = LoggerFactory.getLogger(WebClientProtocolRouteServiceImpl.class);
    @Resource
    RegionCertificateMapper regionCertificateMapper;
    @Resource
    private AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper;
    private final Map<Integer, WebClient> webClientMap = new ConcurrentHashMap<Integer, WebClient>();

    @Override
    public Mono<MsgContext> send(MsgContext msgContext) throws AbilityException {
        Mono<ClientResponse> clientResponseMono;
        TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        Map overtimeMap = esbAbility.getOvertime();
        Map retryTimeMap = esbAbility.getRetryTime();
        Integer overtime = (Integer)overtimeMap.get(regionBO.getRegionId());
        Integer retryTime = (Integer)retryTimeMap.get(regionBO.getRegionId());
        String outputTransProtocal = esbAbility.getOutputTransProtocal();
        TlogRspHeader tlogRspHeader = new TlogRspHeader();
        File file = null;
        String url = CallInterfaceHandler.getUrl(msgContext, this.abilityProvideHttpCustomMapper);
        selfDefHeader.setUrl(url);
        String jsonStr = new String(tlogReqHeader.getReqData(), Consts.UTF_8);
        if (msgContext.getSecurityInfo().isEncryptBody() == Boolean.TRUE.booleanValue()) {
            jsonStr = new String(Base64.encodeBase64((byte[])tlogReqHeader.getReqData()));
        }
        PrintTLogUtil.printRespondInLog(msgContext);
        WebClient webClient = null;
        try {
            webClient = this.getWebClient(regionBO, overtime);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6webClient\u5f02\u5e38", (Throwable)e);
            return Mono.error((Throwable)new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u5ba2\u6237\u7aef"})));
        }
        if (Boolean.TRUE.equals(msgContext.getAbilityToVega().getToVega())) {
            jsonStr = new String(tlogReqHeader.getReqData(), Consts.UTF_8);
            clientResponseMono = this.doPost(webClient, msgContext.getAbilityToVega().getRouterAddress(), (Map<String, String>)msgContext.getSelfDefHeader().getSelfDefMap(), jsonStr, retryTime);
        } else if ("GET".equalsIgnoreCase(outputTransProtocal)) {
            try {
                clientResponseMono = this.doGet(webClient, url, msgContext.getSelfDefHeader().getSelfDefMap(), msgContext.getTlogReqHeader().getReqObj(msgContext), jsonStr, retryTime, msgContext.getWebClientTranscoding());
            }
            catch (IllegalAccessException e) {
                log.error("\u65e0\u6cd5\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u503c", (Throwable)e);
                return Mono.error((Throwable)new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":\u65e0\u6cd5\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u503c"})));
            }
            catch (UnsupportedEncodingException e) {
                log.error("URL\u7f16\u7801\u5931\u8d25", (Throwable)e);
                return Mono.error((Throwable)new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":URL\u7f16\u7801\u5931\u8d25"})));
            }
            catch (JsonProcessingException e) {
                log.error("jackson\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
                return Mono.error((Throwable)new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":jackson\u5e8f\u5217\u5316\u5931\u8d25"})));
            }
        } else if (((String)msgContext.getSelfDefHeader().getSelfDefMap().get("Content-Type")).startsWith("multipart/form-data")) {
            String mapStr = new String(tlogReqHeader.getReqData(), Consts.UTF_8);
            Map map = GsonUtil.toStringMap((String)mapStr);
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equals("fileUploadConstants")) {
                    file = new File((String)entry.getValue());
                    FileSystemResource resource = new FileSystemResource(file);
                    multiValueMap.add((Object)"file", (Object)resource);
                    continue;
                }
                multiValueMap.add(entry.getKey(), entry.getValue());
            }
            clientResponseMono = this.doPost(webClient, url, (Map<String, String>)msgContext.getSelfDefHeader().getSelfDefMap(), (MultiValueMap<String, Object>)multiValueMap, retryTime);
        } else {
            clientResponseMono = this.doPost(webClient, url, (Map<String, String>)msgContext.getSelfDefHeader().getSelfDefMap(), jsonStr, retryTime);
        }
        File finalFile = file;
        return clientResponseMono.flatMap(response -> response.bodyToMono(byte[].class).flatMap(body -> {
            tlogRspHeader.setHeaders(response.headers().asHttpHeaders().toSingleValueMap());
            msgContext.setTlogRspHeader(tlogRspHeader);
            msgContext.getTlogRspHeader().setRspData(body);
            PrintTLogUtil.printRespondOutLog(msgContext);
            if (!ObjectUtils.isEmpty((Object)finalFile)) {
                if (FileUtils.deleteTempFile(finalFile)) {
                    log.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u6210\u529f!");
                } else {
                    log.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25!");
                }
            }
            return Mono.just((Object)msgContext);
        }));
    }

    @Override
    public MsgContext sendMsCxt(MsgContext msgContext) throws AbilityException {
        return null;
    }

    private WebClient getWebClient(RegionBO regionBO, Integer overtime) throws Exception {
        if (!regionBO.getCallProtocol().equals(Constants.Http.HTTPS_INT)) {
            return this.getMyClients(overtime);
        }
        if (regionBO.getTrustAllCertificate().equals(Constants.TrustManager.TRUSTALL)) {
            if (regionBO.getCallAuthenticate().equals(Constants.HttpAuthenticate.SINGLE)) {
                return WebClientStaticFactory.getWebClientAndTrustAll(overtime);
            }
            RegionCertificatePO regionCertificatePO = this.regionCertificateMapper.queryByRegionId(regionBO.getRegionId());
            ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getCertificate()));
            return WebClientStaticFactory.getWebClientWithCertificateAndTrustAll(certificateInputStream, regionCertificatePO.getCerKeypass(), overtime);
        }
        RegionCertificatePO regionCertificatePO = this.regionCertificateMapper.queryByRegionId(regionBO.getRegionId());
        if (regionBO.getCallAuthenticate().equals(Constants.HttpAuthenticate.SINGLE)) {
            if (regionCertificatePO == null || regionCertificatePO.getTrustKeystore() == null) {
                return WebClientStaticFactory.getWebClient(overtime);
            }
            ByteArrayInputStream trustKeystoreInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getTrustKeystore()));
            return WebClientStaticFactory.getWebClientWithTrustStore(trustKeystoreInputStream, regionCertificatePO.getTrustKeystoreKeypass(), overtime);
        }
        if (regionCertificatePO.getTrustKeystore() == null) {
            ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getCertificate()));
            return WebClientStaticFactory.getWebClientWithCertificateBySecurity(certificateInputStream, regionCertificatePO.getCerKeypass(), overtime);
        }
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getCertificate()));
        ByteArrayInputStream trustKeystoreInputStream = new ByteArrayInputStream(Base64Utils.decode((String)regionCertificatePO.getTrustKeystore()));
        return WebClientStaticFactory.getWebClient(certificateInputStream, regionCertificatePO.getCerKeypass(), trustKeystoreInputStream, regionCertificatePO.getTrustKeystoreKeypass(), overtime);
    }

    private Mono<ClientResponse> doPost(WebClient webClient, String url, Map<String, String> myHeader, String jsonStr, Integer retryTime) {
        log.info("POST---WebClient---\u843d\u5730\u5730\u5740: {}", (Object)url);
        log.info("POST---WebClient---\u843d\u5730\u62a5\u6587\uff1a{}", (Object)jsonStr);
        log.info("POST---WebClient---\u8bf7\u6c42\u5934\uff1a{}", myHeader);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> {
            if (myHeader != null && myHeader.size() > 0) {
                myHeader.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
        })).body(BodyInserters.fromObject((Object)jsonStr)).exchange().flatMap(response -> {
            if (response.statusCode().value() == 200) {
                return Mono.just((Object)response);
            }
            return response.bodyToMono(String.class).flatMap(body -> Mono.error((Throwable)new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":" + response.statusCode().value() + ":" + body}))));
        }).retry((long)retryTime.intValue());
    }

    private Mono<ClientResponse> doPost(WebClient webClient, String url, Map<String, String> myHeader, MultiValueMap<String, Object> multiValueMap, Integer retryTime) {
        log.info("POST---WebClient---\u843d\u5730\u5730\u5740: {}", (Object)url);
        log.info("POST---WebClient---\u843d\u5730\u62a5\u6587\uff1a{}", multiValueMap);
        log.info("POST---WebClient---\u8bf7\u6c42\u5934\uff1a{}", myHeader);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).headers(httpHeaders -> {
            if (myHeader != null && myHeader.size() > 0) {
                myHeader.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
        })).body((BodyInserter)BodyInserters.fromMultipartData(multiValueMap)).exchange().flatMap(response -> {
            if (response.statusCode().value() == 200 || response.statusCode().value() == 400) {
                return Mono.just((Object)response);
            }
            return response.bodyToMono(String.class).flatMap(body -> Mono.error((Throwable)new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":" + response.statusCode().value() + ":" + body}))));
        }).retry((long)retryTime.intValue());
    }

    private Mono<ClientResponse> doGet(WebClient webClient, String url, Map<String, String> myHeader, Object object, String jsonStr, Integer retryTime, Boolean webClientTranscoding) throws IllegalAccessException, UnsupportedEncodingException, JsonProcessingException {
        Map mapType = (Map)JSON.parseObject((String)jsonStr, Map.class);
        log.info("GET---WebClient---\u8f6c\u6362\u524d\u62a5\u6587: object-->{}", object);
        log.info("GET---WebClient---\u8f6c\u6362\u524d\u62a5\u6587: jsonStr-->{}", (Object)jsonStr);
        log.info("GET---WebClient---\u8f6c\u6362\u524d\u62a5\u6587: mapType-->{}", (Object)mapType);
        try {
            if (object != null) {
                URIBuilder uriBuilder = new URIBuilder(url);
                JSONObject map = JSON.parseObject((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
                for (Map.Entry entry : map.entrySet()) {
                    uriBuilder.setParameter(entry.getKey().toString(), String.valueOf(entry.getValue()));
                }
                url = uriBuilder.toString();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new AbilityException("Get\u843d\u5730\u62a5\u6587\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
        }
        log.info("GET---WebClient---\u843d\u5730\u5730\u5740: {}", (Object)url);
        log.info("GET---WebClient---\u8bf7\u6c42\u5934\uff1a{}", myHeader);
        DefaultUriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory();
        if (Boolean.FALSE.equals(webClientTranscoding)) {
            uriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        }
        UriBuilder uri = uriBuilderFactory.uriString(url);
        return webClient.get().uri(uri.build(new Object[0])).headers(httpHeaders -> {
            if (myHeader != null && myHeader.size() > 0) {
                myHeader.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
        }).exchange().flatMap(response -> {
            if (response.statusCode().value() == 200) {
                return Mono.just((Object)response);
            }
            return response.bodyToMono(String.class).flatMap(body -> Mono.error((Throwable)new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":" + response.statusCode().value() + ":" + body}))));
        }).retry((long)retryTime.intValue());
    }

    public WebClient getMyClients(Integer overTime) {
        WebClient webClient = this.webClientMap.get(overTime);
        if (webClient != null) {
            return webClient;
        }
        webClient = WebClientStaticFactory.getWebClient(overTime);
        this.putMyClients(overTime, webClient);
        return webClient;
    }

    public void putMyClients(Integer overTime, WebClient webClient) {
        this.webClientMap.put(overTime, webClient);
    }
}

