/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.esb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.LimitConstant;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.js.MngHelperService;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.AbilityToVega;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SecurityInfo;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.JacksonUtil;
import com.ohaotian.abilitycommon.util.JaxbUtil;
import com.ohaotian.abilitycommon.util.JsonXmlUtil;
import com.ohaotian.abilitycommon.util.UrlUtil;
import com.ohaotian.abilityweb.config.esbability.EsbAbilityMap;
import com.ohaotian.abilityweb.mapper.RateLimiterSubscribeMapper;
import com.ohaotian.abilityweb.model.bo.EsbDefaultServerRequest;
import com.ohaotian.abilityweb.model.po.RateLimiterSubscribePO;
import com.ohaotian.abilityweb.service.abnormal.AbnormalGrabService;
import com.ohaotian.abilityweb.service.balance.LoadBalanceService;
import com.ohaotian.abilityweb.service.check.hpaty.HpatyCheckService;
import com.ohaotian.abilityweb.service.check.message.MessageProtocolFactory;
import com.ohaotian.abilityweb.service.check.message.ValidMessageService;
import com.ohaotian.abilityweb.service.check.subscribe.FactoryForSubscribeCheck;
import com.ohaotian.abilityweb.service.client.UnifiedCallService;
import com.ohaotian.abilityweb.service.esb.EsbService;
import com.ohaotian.abilityweb.service.limit.global.JudgeRateLimiterService;
import com.ohaotian.abilityweb.service.limit.single.EsbAbilityAppLimitMap;
import com.ohaotian.abilityweb.service.limit.single.EsbAbilityLimitMap;
import com.ohaotian.abilityweb.service.plugin.BusinessService;
import com.ohaotian.abilityweb.service.plugin.CheckService;
import com.ohaotian.abilityweb.service.plugin.RouteService;
import com.ohaotian.abilityweb.service.proxy.BuildProxyMsgService;
import com.ohaotian.abilityweb.service.safety.SecurityReinService;
import com.ohaotian.abilityweb.service.token.TokenRefresh;
import com.ohaotian.abilityweb.service.transform.FactoryForTransForm;
import com.ohaotian.abilityweb.service.vega.AbilityToVegaService;
import com.ohaotian.abilityweb.util.FileUtils;
import com.ohaotian.abilityweb.util.PrintTLogUtil;
import com.ohaotian.plugin.cache.CacheClient;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.script.ScriptException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.Part;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class EsbServiceImpl
implements EsbService {
    private static final Logger log = LoggerFactory.getLogger(EsbServiceImpl.class);
    @Resource
    private CheckService checkService;
    @Resource
    private BusinessService businessService;
    @Resource
    private RouteService routeService;
    @Resource
    private FactoryForSubscribeCheck factoryForSubscribeCheck;
    @Resource
    private HpatyCheckService hpatyCheckService;
    @Resource
    private LoadBalanceService loadBalanceService;
    @Resource
    private ValidMessageService validMessageService;
    @Resource
    private UnifiedCallService unifiedCallService;
    @Resource
    private FactoryForTransForm factoryTransformer;
    @Resource
    private BuildProxyMsgService buildProxyMsgService;
    @Resource
    private JudgeRateLimiterService judgeRateLimiterService;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Resource
    private RateLimiterSubscribeMapper rateLimiterSubscribeMapper;
    @Autowired
    private AbilityToVegaService abilityToVegaService;
    @Resource
    private CacheClient cacheClient;
    @Resource
    private SecurityReinService securityReinService;
    @Value(value="${ability.securityInfo.sign:null}")
    private String sign;
    @Value(value="${ability.securityInfo.encryptBody:false}")
    private boolean encryptBody;
    @Value(value="${ability.securityInfo.preventAgain:true}")
    private boolean preventAgain;
    @Value(value="${ability.webClient.transcoding:true}")
    private boolean webClientTranscoding;
    @Value(value="${ability.to.vega:false}")
    private boolean toVega;
    @Resource
    private TokenRefresh refreshCHPC;
    @Autowired
    private AbnormalGrabService abnormalGrabService;
    @Autowired
    private MngHelperService mngHelperService;

    @Override
    public Mono<String> doService(ServerRequest serverRequest, MsgContext msgCont) throws AbilityException {
        return this.checkHead(serverRequest).flatMap(body -> this.initMsgContext(serverRequest, (String)body, msgCont)).flatMap(msgContext -> {
            this.factoryForSubscribeCheck.getStrategy((MsgContext)msgContext).doSubscribeCheckFromHeader((MsgContext)msgContext);
            this.validMessageService.doValidateReq((MsgContext)msgContext);
            this.factoryForSubscribeCheck.getStrategy((MsgContext)msgContext).doSubscribeCheckFromBody((MsgContext)msgContext);
            this.checkService.doService((MsgContext)msgContext);
            this.checkSingleAbilityLimit((MsgContext)msgContext);
            this.checkSingleSubscribeLimit((MsgContext)msgContext);
            return this.judgeRateLimiterService.judgeRate((MsgContext)msgContext);
        }).flatMap(msgContext -> {
            this.businessService.doService((MsgContext)msgContext);
            this.formate((MsgContext)msgContext);
            return this.dealMainService((MsgContext)msgContext);
        }).flatMap(msgContext -> {
            this.factoryTransformer.getStrategy(msgContext.getEsbAbility().getRspTransType()).invokeTransBack((MsgContext)msgContext);
            this.validMessageService.doValidateRsp((MsgContext)msgContext);
            this.formateRsp((MsgContext)msgContext);
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList();
            for (AbilityPluginBO abilityPluginBO : abilityPluginBOList) {
                if (!Boolean.TRUE.equals(abilityPluginBO.getDealJudgeRsp())) continue;
                this.routeService.doService((MsgContext)msgContext);
            }
            this.refreshCHPC.doRefresh((MsgContext)msgContext);
            String rsp = msgContext.getTlogRspHeader().getRspDataString();
            if (rsp.contains("\"success\":\"false\"") || rsp.contains("\"success\":false")) {
                this.abnormalGrabService.landingReturn((MsgContext)msgContext);
            }
            return Mono.just((Object)rsp);
        });
    }

    private Mono<String> checkHead(ServerRequest serverRequest) {
        JsonMapper jsonMapper = new JsonMapper();
        LinkedHashMap hashMap = Maps.newLinkedHashMap();
        if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith((MediaType)serverRequest.headers().contentType().get())) {
            return serverRequest.formData().flatMap(map -> {
                try {
                    map.forEach((k, v) -> hashMap.put(k, v.get(0)));
                    log.info("\u8bf7\u6c42[{}]\u62a5\u6587\u4e3a{}", (Object)"application/x-www-form-urlencoded", (Object)hashMap);
                    return Mono.just((Object)jsonMapper.writeValueAsString((Object)hashMap));
                }
                catch (JsonProcessingException e) {
                    return Mono.error((Throwable)e);
                }
            });
        }
        if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith((MediaType)serverRequest.headers().contentType().get())) {
            return serverRequest.multipartData().flatMap(map -> {
                map.forEach((k, v) -> {
                    Flux content = ((Part)v.get(0)).content();
                    String contentDisposition = (String)((Part)v.get(0)).headers().get((Object)"content-disposition").get(0);
                    if (contentDisposition.contains("filename")) {
                        if (!ObjectUtils.isEmpty((Object)this.cacheClient.get("fileResource"))) {
                            throw new RuntimeException("\u670d\u52a1\u6b63\u5fd9\uff01");
                        }
                        this.cacheClient.set("fileResource", (Object)"1");
                        this.cacheClient.expire("fileResource", 10);
                        content.subscribe(buffer -> {
                            byte[] bytes = new byte[buffer.readableByteCount()];
                            buffer.read(bytes);
                            DataBufferUtils.release((DataBuffer)buffer);
                            FileUtils.cacheBytes(bytes);
                        });
                        String suffix = contentDisposition.substring(contentDisposition.lastIndexOf(".")).replaceAll("\"", "");
                        String filePath = "";
                        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + System.currentTimeMillis() + suffix;
                        FileUtils.byte2File(FileUtils.getBytes(), filePath, fileName);
                        FileUtils.clear();
                        hashMap.put("fileUploadConstants", filePath + fileName);
                        this.cacheClient.delete("fileResource");
                    } else {
                        content.subscribe(buffer -> {
                            byte[] bytes = new byte[buffer.readableByteCount()];
                            buffer.read(bytes);
                            DataBufferUtils.release((DataBuffer)buffer);
                            String bodyString = null;
                            try {
                                bodyString = new String(bytes, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            hashMap.put(k, bodyString);
                        });
                    }
                });
                try {
                    log.info("\u8bf7\u6c42[{}]\u62a5\u6587\u4e3a{}", (Object)"multipart/form-data", (Object)hashMap);
                    return Mono.just((Object)jsonMapper.writeValueAsString((Object)hashMap));
                }
                catch (JsonProcessingException e) {
                    return Mono.error((Throwable)e);
                }
            });
        }
        if (serverRequest.method().equals((Object)HttpMethod.POST)) {
            return serverRequest.bodyToMono(String.class);
        }
        return Mono.just((Object)GsonUtil.toJson((Object)serverRequest.exchange().getRequest().getQueryParams().toSingleValueMap()));
    }

    public String callSubService(MsgContext msgContext) throws NoSuchFieldException, IllegalAccessException {
        PrintTLogUtil.printRequestInLog(null, msgContext);
        this.abilityUnifiedConfiguration(msgContext);
        this.validMessageService.doValidateReq(msgContext);
        this.businessService.doService(msgContext);
        this.formate(msgContext);
        this.dealSubService(msgContext);
        this.factoryTransformer.getStrategy(msgContext.getEsbAbility().getRspTransType()).invokeTransBack(msgContext);
        this.validMessageService.doValidateRsp(msgContext);
        this.formateRsp(msgContext);
        PrintTLogUtil.printRequestOutLog(msgContext);
        return msgContext.getTlogRspHeader().getRspDataString();
    }

    private Mono<MsgContext> dealMainService(MsgContext msgContext) {
        Integer abilityType = msgContext.getEsbAbility().getAbilityType();
        if (abilityType == 0) {
            this.abilityToVegaService.init(msgContext);
            this.hpatyCheckService.doHpatyCheck(msgContext);
            this.routeService.doService(msgContext);
            this.loadBalanceService.getRegionAddr(msgContext);
            this.buildProxyMsgService.buildProxyReqHead(msgContext);
            this.factoryTransformer.getStrategy(msgContext.getEsbAbility().getReqTransType()).invokeTransFront(msgContext);
            if (Boolean.FALSE.equals(msgContext.getSkipRequest())) {
                this.refreshCHPC.doSplicing(msgContext);
                this.abilityToVegaService.doService(msgContext);
                this.securityReinService.reinforcement(msgContext);
                if (((String)msgContext.getSelfDefHeader().getSelfDefMap().get("Content-Type")).startsWith("application/x-www-form-urlencoded")) {
                    return this.unifiedCallService.getStrategy("HttpClient").getStrategy(msgContext.getRequestMode()).send(msgContext);
                }
                if ("PushClient".equals(msgContext.getEsbAbility().getOutputClient())) {
                    return this.unifiedCallService.getStrategy(msgContext.getEsbAbility().getOutputClient()).getStrategy(msgContext.getEsbAbility().getOutputTransProtocal()).send(msgContext);
                }
                return this.unifiedCallService.getStrategy(msgContext.getEsbAbility().getOutputClient()).getStrategy(msgContext.getRequestMode()).send(msgContext);
            }
            log.warn("\u8df3\u8fc7\u843d\u5730\u8bf7\u6c42\uff01");
            msgContext.getTlogReqHeader().setReqData("{\"message\": \"\u8be5\u80fd\u529b\u8df3\u8fc7\u843d\u5730\u8bf7\u6c42\"}".getBytes(StandardCharsets.UTF_8));
            PrintTLogUtil.printRespondInLog(msgContext);
            PrintTLogUtil.printRespondOutLog(msgContext);
            return Mono.just((Object)msgContext);
        }
        return Mono.just((Object)msgContext).publishOn(Schedulers.boundedElastic()).flatMap(msgContext1 -> {
            this.invokeComLogic((MsgContext)msgContext1);
            return Mono.just((Object)msgContext1);
        });
    }

    private void dealSubService(MsgContext msgContext) throws NoSuchFieldException, IllegalAccessException {
        Integer abilityType = msgContext.getEsbAbility().getAbilityType();
        if (abilityType == 0) {
            this.hpatyCheckService.doHpatyCheck(msgContext);
            this.routeService.doService(msgContext);
            this.loadBalanceService.getRegionAddr(msgContext);
            this.buildProxyMsgService.buildProxyReqHead(msgContext);
            this.factoryTransformer.getStrategy(msgContext.getEsbAbility().getReqTransType()).invokeTransFront(msgContext);
            if (Boolean.FALSE.equals(msgContext.getSkipRequest())) {
                this.securityReinService.reinforcement(msgContext);
                if ("PushClient".equals(msgContext.getEsbAbility().getOutputClient())) {
                    this.unifiedCallService.getStrategy("PushClient").getStrategy(msgContext.getEsbAbility().getOutputTransProtocal()).sendMsCxt(msgContext);
                } else {
                    this.unifiedCallService.getStrategy("HttpClient").getStrategy(msgContext.getRequestMode()).sendMsCxt(msgContext);
                }
            } else {
                log.warn("\u8df3\u8fc7\u843d\u5730\u8bf7\u6c42\uff01");
                msgContext.getTlogReqHeader().setReqData("{\"message\": \"\u8be5\u80fd\u529b\u8df3\u8fc7\u843d\u5730\u8bf7\u6c42\"}".getBytes(StandardCharsets.UTF_8));
                PrintTLogUtil.printRespondInLog(msgContext);
                PrintTLogUtil.printRespondOutLog(msgContext);
            }
        } else if (abilityType == 1) {
            this.invokeComLogic(msgContext);
        }
    }

    private Mono<MsgContext> initMsgContext(ServerRequest request, String originalBody, MsgContext msgContext) {
        EsbDefaultServerRequest esbDefaultServerRequest = (EsbDefaultServerRequest)request;
        this.securityReinService.relaunchAttack(originalBody);
        this.initAbility(request, msgContext);
        SelfDefHeader selfDefHeader = new SelfDefHeader();
        selfDefHeader.setSysTransId(esbDefaultServerRequest.getTransId());
        selfDefHeader.setClusterId(this.nodeInfoConfig.getClusterId());
        TlogReqHeader tlogReqHeader = new TlogReqHeader();
        HttpMethod method = request.method();
        tlogReqHeader.setMethod(method.name());
        if (StringUtils.isNotBlank((CharSequence)originalBody) && '[' == originalBody.charAt(0) && ']' == originalBody.charAt(originalBody.length() - 1)) {
            msgContext.setBodyListFlag(Boolean.TRUE);
        }
        tlogReqHeader.setReqData(originalBody.getBytes(Consts.UTF_8));
        ConcurrentHashMap headersMap = new ConcurrentHashMap();
        ConcurrentHashMap<String, Object> selfHeadersMap = new ConcurrentHashMap<String, Object>();
        HttpHeaders httpHeaders = request.headers().asHttpHeaders();
        for (Map.Entry next : httpHeaders.entrySet()) {
            headersMap.put(next.getKey(), ((List)next.getValue()).get(0));
            if (!((String)next.getKey()).startsWith("ESB-")) continue;
            selfHeadersMap.put(((String)next.getKey()).substring(4), ((List)next.getValue()).get(0));
        }
        MultiValueMap queryParams = request.exchange().getRequest().getQueryParams();
        HashMap queryParamsMap = new HashMap();
        queryParams.forEach((k, y) -> queryParamsMap.put(k, y));
        if (StringUtils.isEmpty((CharSequence)((CharSequence)headersMap.get("Content-Type")))) {
            headersMap.put("Content-Type", MessageProtocolFactory.getInstance(msgContext.getInputProtocal()).getcontentType());
        }
        selfHeadersMap.put("Content-Type", MessageProtocolFactory.getInstance(msgContext.getEsbAbility().getOutputProtocal()).getcontentType());
        tlogReqHeader.setHeadersMap(headersMap);
        selfDefHeader.setSelfDefMap(selfHeadersMap);
        String businessCenterCode = (String)headersMap.get("dycCenterCode");
        if (ObjectUtils.isEmpty((Object)businessCenterCode) && Boolean.FALSE.equals(msgContext.getBodyListFlag())) {
            String dycCenterCode = "";
            try {
                String tmpCode = com.alibaba.fastjson.JSON.parseObject((String)originalBody).getString("dycCenterCode");
                if (!ObjectUtils.isEmpty((Object)tmpCode)) {
                    dycCenterCode = tmpCode;
                }
            }
            catch (Exception e) {
                log.warn("\u5165\u53c2\u4e2d\u83b7\u53d6dycCenterCode\u5f02\u5e38\uff01ex:{}", (Object)e.getMessage());
            }
            msgContext.setBusinessCenterCode(dycCenterCode);
        } else {
            msgContext.setBusinessCenterCode(businessCenterCode);
        }
        msgContext.setSelfDefHeader(selfDefHeader);
        String ip = ((InetSocketAddress)request.remoteAddress().get()).getAddress().getHostAddress();
        tlogReqHeader.setFromIp(ip);
        tlogReqHeader.setReqRecvStartTime(System.currentTimeMillis());
        msgContext.setTlogReqHeader(tlogReqHeader);
        log.info("\u8bf7\u6c42\u80fd\u529b abilityId --> {}|{}|{}", new Object[]{msgContext.getEsbAbility().getAbilityId(), msgContext.getEsbAbility().getAbilityName(), msgContext.getEsbAbility().getAbilityEname()});
        log.info("\u8bf7\u6c42\u5e94\u7528 providerApp --> {}|{}|{}", new Object[]{msgContext.getEsbAbility().getProviderApp().getAppId(), msgContext.getEsbAbility().getProviderApp().getAppName(), msgContext.getEsbAbility().getProviderApp().getAppCode()});
        PrintTLogUtil.printRequestInLog(request, msgContext);
        return Mono.just((Object)msgContext);
    }

    private void initAbility(ServerRequest request, MsgContext msgContext) {
        try {
            String abilityAliasName = UrlUtil.getAbilityInfo((String)request.path(), (MsgContext)msgContext);
            EsbAbility esbAbility = EsbAbilityMap.getAbility(abilityAliasName);
            if (esbAbility == null) {
                throw new AbilityException(CodeMsg.E_REQ_SVC_MARK_ERROR.fillArgs(new Object[]{":" + request.path()}));
            }
            if (esbAbility.getAttendStatus() == 0) {
                throw new AbilityException(CodeMsg.E_SVC_SIGN_OUT.fillArgs(new Object[]{":" + abilityAliasName}));
            }
            msgContext.setEsbAbility(esbAbility);
            String supportProtocal = msgContext.getEsbAbility().getInputProtocal();
            if (!supportProtocal.contains(msgContext.getInputProtocal())) {
                throw new AbilityException(CodeMsg.E_REQ_VALID_REQ_ERROR.fillArgs(new Object[]{":\u80fd\u529b\u672a\u914d\u7f6e" + msgContext.getInputProtocal() + "\u63a5\u5165"}));
            }
            msgContext.setAbilityToVega(new AbilityToVega());
            msgContext.getAbilityToVega().setRouterAddress(request.path());
            this.abilityUnifiedConfiguration(msgContext);
        }
        catch (AbilityException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_REQ_SVC_MARK_ERROR.fillArgs(new Object[]{":" + request.path()}));
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error("\u7cfb\u7edf\u5f02\u5e38", t);
            throw new AbilityException(CodeMsg.E_REQ_SVC_MARK_ERROR.fillArgs(new Object[]{":" + request.path()}));
        }
    }

    private void abilityUnifiedConfiguration(MsgContext msgContext) {
        msgContext.setSecurityInfo(new SecurityInfo());
        msgContext.getSecurityInfo().setSign(this.sign);
        msgContext.getSecurityInfo().setPreventAgain(this.preventAgain);
        msgContext.getSecurityInfo().setEncryptBody(this.encryptBody);
        msgContext.setWebClientTranscoding(Boolean.valueOf(this.webClientTranscoding));
        msgContext.getAbilityToVega().setToVega(Boolean.valueOf(this.toVega));
    }

    private void checkSingleAbilityLimit(MsgContext msgContext) {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        AppBO providerApp = esbAbility.getProviderApp();
        AppBO consumerApp = msgContext.getSelfDefHeader().getApp();
        if (consumerApp == null) {
            return;
        }
        if (providerApp.getAppCode().equals(consumerApp.getAppCode())) {
            return;
        }
        if (LimitConstant.SINGLE_LIMIT_ON.equalsIgnoreCase(esbAbility.getSingleLimit())) {
            if (EsbAbilityLimitMap.isCountOverLimit(esbAbility.getAbilityId(), esbAbility.getSingleMaxCount())) {
                throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SINGLE_ABILITY_SEND_COUNT);
            }
            if (EsbAbilityLimitMap.isDaylyCountOverLimit(esbAbility.getAbilityId(), esbAbility.getSingleDailyMaxCount())) {
                throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SINGLE_ABILITY_DAILY_SEND_COUNT);
            }
            if (EsbAbilityLimitMap.isRateOverLimit(esbAbility.getAbilityId(), esbAbility.getSingleMaxRate())) {
                throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SINGLE_ABILITY_SEND_RATE);
            }
        }
    }

    private void checkSingleSubscribeLimit(MsgContext msgContext) {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        AppBO consumerApp = msgContext.getSelfDefHeader().getApp();
        AppBO providerApp = esbAbility.getProviderApp();
        if (consumerApp == null) {
            return;
        }
        if (providerApp.getAppCode().equals(consumerApp.getAppCode())) {
            return;
        }
        if (LimitConstant.SINGLE_LIMIT_ON.equalsIgnoreCase(esbAbility.getSingleLimit())) {
            RateLimiterSubscribePO rateLimiterSubscribePO = new RateLimiterSubscribePO();
            rateLimiterSubscribePO.setAbilityId(esbAbility.getAbilityId());
            rateLimiterSubscribePO.setAppId(consumerApp.getAppId());
            rateLimiterSubscribePO = this.rateLimiterSubscribeMapper.queryLimitOne(rateLimiterSubscribePO);
            if (rateLimiterSubscribePO != null) {
                String key = rateLimiterSubscribePO.getAbilityId() + "_" + rateLimiterSubscribePO.getAppId();
                boolean isCountLimit = EsbAbilityAppLimitMap.isOverLimitCount(key, rateLimiterSubscribePO.getSingleMaxCount());
                if (isCountLimit) {
                    throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SINGLE_ABILITY_APP_SEND_COUNT);
                }
                boolean isDailyCountLimit = EsbAbilityAppLimitMap.isOverLimitDailyCount(key, rateLimiterSubscribePO.getSingleDailyMaxCount());
                if (isDailyCountLimit) {
                    throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SINGLE_ABILITY_APP_DAILY_SEND_COUNT);
                }
                boolean isSpeedLimit = EsbAbilityAppLimitMap.isOverLimitRate(key, rateLimiterSubscribePO.getSingleMaxRate());
                if (isSpeedLimit) {
                    throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SINGLE_ABILITY_APP_SEND_RATE);
                }
            }
        }
    }

    private void formate(MsgContext msgContext) {
        if (msgContext.getUniformityFlag().booleanValue()) {
            return;
        }
        try {
            TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
            switch (msgContext.getEsbAbility().getOutputProtocal()) {
                case "json": {
                    if (!msgContext.getEsbAbility().getInputProtocal().equals("xml")) break;
                    tlogReqHeader.setReqData(JacksonUtil.toJson((Object)tlogReqHeader.getReqObj(msgContext)).getBytes());
                    break;
                }
                case "xml": {
                    tlogReqHeader.setReqData(JaxbUtil.beanToXml((Object)tlogReqHeader.getReqObj(msgContext), (JAXBContext)msgContext.getEsbAbility().getContextReq(), (String)"UTF-8").getBytes());
                    break;
                }
                case "ws": {
                    break;
                }
                case "dubbo": {
                    tlogReqHeader.setReqData(JacksonUtil.toJson((Object)tlogReqHeader.getReqObj(msgContext)).getBytes());
                    break;
                }
                case "hsf": {
                    tlogReqHeader.setReqData(JacksonUtil.toJson((Object)tlogReqHeader.getReqObj(msgContext)).getBytes());
                    break;
                }
                case "formData": {
                    break;
                }
            }
        }
        catch (JsonProcessingException | JAXBException e) {
            log.error("\u62a5\u6587\u683c\u5f0f\u5316\u9519\u8bef", e);
            throw new AbilityException(CodeMsg.ESB_ERROR.fillArgs(new Object[]{":" + e.getMessage()}), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formateRsp(MsgContext msgContext) {
        block11: {
            if (!msgContext.getUniformityFlag().booleanValue()) {
                try {
                    String inputProtocal = msgContext.getInputProtocal();
                    String outputProtocal = msgContext.getEsbAbility().getOutputProtocal();
                    if (inputProtocal.equals("xml")) {
                        if (outputProtocal.equals("xml")) {
                            msgContext.getTlogRspHeader().setRspData(JaxbUtil.beanToXml((Object)msgContext.getTlogRspHeader().getRspObj(msgContext), (JAXBContext)msgContext.getEsbAbility().getContextRsp(), (String)"UTF-8").getBytes());
                            break block11;
                        }
                        if (outputProtocal.equals("json")) {
                            JSONObject json = JSONObject.fromObject((Object)new String(JacksonUtil.toJson((Object)msgContext.getTlogRspHeader().getRspObj()).getBytes(), Consts.UTF_8));
                            XMLSerializer xmlSerializer = new XMLSerializer();
                            String xml = xmlSerializer.write((JSON)json);
                            msgContext.getTlogRspHeader().setRspData(xml.getBytes());
                        }
                        break block11;
                    }
                    if (inputProtocal.equals("ws")) {
                        msgContext.getTlogRspHeader().setRspData(JaxbUtil.beanToXml((Object)msgContext.getTlogRspHeader().getRspObj(msgContext), (JAXBContext)msgContext.getEsbAbility().getContextRsp(), (String)"UTF-8").getBytes());
                        break block11;
                    }
                    if (!inputProtocal.equals("json")) break block11;
                    if (outputProtocal.equals("xml")) {
                        String xml = msgContext.getRspText();
                        Map map = JsonXmlUtil.xml2Map((String)xml);
                        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject(map);
                        msgContext.getTlogRspHeader().setRspData(json.toJSONString().getBytes());
                        break block11;
                    }
                    if (outputProtocal.equals("json")) {
                        msgContext.getTlogRspHeader().setRspData(JacksonUtil.toJson((Object)msgContext.getTlogRspHeader().getRspObj()).getBytes());
                    } else if (!outputProtocal.equals("formData")) {
                        // empty if block
                    }
                }
                catch (JsonProcessingException | JAXBException e) {
                    throw new AbilityException(CodeMsg.ESB_ERROR.fillArgs(new Object[]{":" + e.getMessage()}), e);
                }
            }
        }
        msgContext.getTlogRspHeader().setRspDataString(new String(msgContext.getTlogRspHeader().getRspData(), msgContext.getRspStringEncoding()));
    }

    private void invokeComLogic(MsgContext msgContext) {
        try {
            Object o;
            log.debug("\u8c03\u7528\u7ec4\u5408\u903b\u8f91");
            TlogRspHeader tlogRspHeader = new TlogRspHeader();
            EsbAbility esbAbility = msgContext.getEsbAbility();
            String funName = esbAbility.getAbilityEname() + esbAbility.getAbilityVersion() + "ComFun";
            funName = funName.replace(".", "_");
            msgContext.setReqText(new String(msgContext.getTlogReqHeader().getReqData(), Consts.UTF_8));
            String logic = msgContext.getEsbAbility().getLogicScript();
            if (!Objects.isNull(logic)) {
                o = this.mngHelperService.eval(funName, logic, new Object[]{msgContext});
                if (!(o instanceof String)) {
                    log.error("\u8fd4\u56de\u7c7b\u578b\u4e0d\u652f\u6301\u5904\u7406");
                    throw new AbilityException(CodeMsg.E_INVOKE_NO_SUPPORT);
                }
            } else {
                throw new AbilityException(CodeMsg.E_INVOKE_NO_LOGIC);
            }
            tlogRspHeader.setRspData(((String)o).getBytes(Consts.UTF_8));
            msgContext.setTlogRspHeader(tlogRspHeader);
        }
        catch (ScriptException e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{":\u6587\u4ef6" + e.getFileName() + "\u4e2d,\u7b2c" + e.getLineNumber() + "\u884c\uff0c\u7b2c" + e.getColumnNumber() + "\u4f4d,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()}));
        }
        catch (Exception e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }
}

