/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.limit.single;

import com.ohaotian.abilityweb.util.ObjectUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class EsbAbilityAppLimitMap {
    private static ConcurrentHashMap<String, AtomicInteger> abilityAppCountMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AtomicInteger> originalDailyMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AtomicInteger> actualDailyMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AtomicInteger> originalRateMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AtomicInteger> actualRateMap = new ConcurrentHashMap();

    public static void putLimit(String abilityAppId) {
        if (abilityAppCountMap.get(abilityAppId) == null) {
            abilityAppCountMap.putIfAbsent(abilityAppId, new AtomicInteger(0));
        }
        if (originalDailyMap.get(abilityAppId) == null) {
            originalDailyMap.putIfAbsent(abilityAppId, new AtomicInteger(0));
            actualDailyMap.putIfAbsent(abilityAppId, new AtomicInteger(0));
        }
        if (originalRateMap.get(abilityAppId) == null) {
            originalRateMap.putIfAbsent(abilityAppId, new AtomicInteger(0));
            actualRateMap.putIfAbsent(abilityAppId, new AtomicInteger(0));
        }
    }

    public static void removeLimit(String abilityAppId) {
        if (abilityAppCountMap.get(abilityAppId) != null) {
            abilityAppCountMap.remove(abilityAppId);
        }
        if (originalDailyMap.get(abilityAppId) != null) {
            originalDailyMap.remove(abilityAppId);
        }
        if (actualDailyMap.get(abilityAppId) != null) {
            actualDailyMap.remove(abilityAppId);
        }
        if (originalRateMap.get(abilityAppId) != null) {
            originalRateMap.remove(abilityAppId);
        }
        if (actualRateMap.get(abilityAppId) != null) {
            actualRateMap.remove(abilityAppId);
        }
    }

    public static void removeLimitByAbilityId(Long abilityId) {
        Set actualRateMapKeys;
        Set originalRateMapKeys;
        Set actualDailyMapKeys;
        Set originalDailyMapKeys;
        Set abilityAppCountKeys = abilityAppCountMap.keySet();
        if (abilityAppCountKeys != null) {
            for (Object key : abilityAppCountKeys) {
                if (!((String)key).substring(0, ((String)key).indexOf("_")).equals(abilityId.toString())) continue;
                abilityAppCountMap.remove(key);
            }
        }
        if ((originalDailyMapKeys = originalDailyMap.keySet()) != null) {
            for (Object key : originalDailyMapKeys) {
                if (!((String)key).substring(0, ((String)key).indexOf("_")).equals(abilityId.toString())) continue;
                originalDailyMap.remove(key);
            }
        }
        if ((actualDailyMapKeys = actualDailyMap.keySet()) != null) {
            for (Object key : actualDailyMapKeys) {
                if (!((String)key).substring(0, ((String)key).indexOf("_")).equals(abilityId.toString())) continue;
                actualDailyMapKeys.remove(key);
            }
        }
        if ((originalRateMapKeys = originalRateMap.keySet()) != null) {
            for (String key : originalRateMapKeys) {
                if (!key.substring(0, key.indexOf("_")).equals(abilityId.toString())) continue;
                originalRateMap.remove(key);
            }
        }
        if ((actualRateMapKeys = actualRateMap.keySet()) != null) {
            for (String key : actualRateMapKeys) {
                if (!key.substring(0, key.indexOf("_")).equals(abilityId.toString())) continue;
                actualRateMap.remove(key);
            }
        }
    }

    public static void resetRate() {
        if (originalRateMap.size() > 0) {
            actualRateMap = (ConcurrentHashMap)ObjectUtil.clone(originalRateMap);
        }
    }

    public static void resetDailyCount() {
        if (originalDailyMap.size() > 0) {
            actualDailyMap = (ConcurrentHashMap)ObjectUtil.clone(originalDailyMap);
        }
    }

    public static boolean isOverLimitCount(String abilityAppId, Integer maxCount) {
        if (maxCount < 0) {
            return false;
        }
        AtomicInteger atomicInteger = abilityAppCountMap.get(abilityAppId);
        int nowCount = atomicInteger.incrementAndGet();
        if (nowCount > maxCount) {
            atomicInteger.decrementAndGet();
            return true;
        }
        return false;
    }

    public static boolean isOverLimitDailyCount(String abilityAppId, Integer dailyCount) {
        if (dailyCount < 0) {
            return false;
        }
        AtomicInteger atomicInteger = actualDailyMap.get(abilityAppId);
        int nowDailyCount = atomicInteger.incrementAndGet();
        if (nowDailyCount > dailyCount) {
            atomicInteger.decrementAndGet();
            abilityAppCountMap.get(abilityAppId).decrementAndGet();
            return true;
        }
        return false;
    }

    public static boolean isOverLimitRate(String abilityAppId, Integer maxRate) {
        if (maxRate < 0) {
            return false;
        }
        AtomicInteger atomicInteger3 = actualRateMap.get(abilityAppId);
        int nowRate = atomicInteger3.incrementAndGet();
        if (nowRate > maxRate) {
            abilityAppCountMap.get(abilityAppId).decrementAndGet();
            actualDailyMap.get(abilityAppId).decrementAndGet();
            return true;
        }
        return false;
    }
}

