/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.limit.single;

import com.ohaotian.abilityweb.util.ObjectUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class EsbAbilityLimitMap {
    private static ConcurrentHashMap<Long, AtomicInteger> originalMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Long, AtomicInteger> actualMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Long, AtomicInteger> originalDailyCountMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Long, AtomicInteger> actualDailyCountMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Long, AtomicInteger> abilityCountMap = new ConcurrentHashMap();

    public static void putAbilityRate(Long abilityId) {
        if (originalMap.get(abilityId) == null) {
            originalMap.putIfAbsent(abilityId, new AtomicInteger(0));
            actualMap.putIfAbsent(abilityId, new AtomicInteger(0));
        }
        if (originalDailyCountMap.get(abilityId) == null) {
            originalDailyCountMap.putIfAbsent(abilityId, new AtomicInteger(0));
            actualDailyCountMap.putIfAbsent(abilityId, new AtomicInteger(0));
        }
        if (abilityCountMap.get(abilityId) == null) {
            abilityCountMap.putIfAbsent(abilityId, new AtomicInteger(0));
        }
    }

    public static void resetRate() {
        if (originalMap.size() > 0) {
            actualMap = (ConcurrentHashMap)ObjectUtil.clone(originalMap);
        }
    }

    public static void resetDailyCount() {
        if (originalDailyCountMap.size() > 0) {
            actualDailyCountMap = (ConcurrentHashMap)ObjectUtil.clone(originalDailyCountMap);
        }
    }

    public static boolean isRateOverLimit(Long abilityId, Integer maxRate) {
        if (maxRate < 0) {
            return false;
        }
        AtomicInteger atomicInteger = actualMap.get(abilityId);
        int nowRate = atomicInteger.incrementAndGet();
        return nowRate > maxRate;
    }

    public static boolean isDaylyCountOverLimit(Long abilityId, Integer maxRate) {
        if (maxRate < 0) {
            return false;
        }
        AtomicInteger atomicInteger = actualDailyCountMap.get(abilityId);
        int nowRate = atomicInteger.incrementAndGet();
        if (nowRate > maxRate) {
            atomicInteger.decrementAndGet();
            return true;
        }
        return false;
    }

    public static boolean isCountOverLimit(Long abilityId, Integer maxCount) {
        if (maxCount < 0) {
            return false;
        }
        AtomicInteger atomicInteger = abilityCountMap.get(abilityId);
        int nowCount = atomicInteger.incrementAndGet();
        if (nowCount > maxCount) {
            atomicInteger.decrementAndGet();
            return true;
        }
        return false;
    }

    public static void removeAbilityRate(Long abilityId) {
        if (originalMap.get(abilityId) != null) {
            originalMap.remove(abilityId);
        }
        if (actualMap.get(abilityId) != null) {
            actualMap.remove(abilityId);
        }
        if (originalDailyCountMap.get(abilityId) != null) {
            originalDailyCountMap.remove(abilityId);
        }
        if (actualDailyCountMap.get(abilityId) != null) {
            actualDailyCountMap.remove(abilityId);
        }
        if (abilityCountMap.get(abilityId) != null) {
            abilityCountMap.remove(abilityId);
        }
    }
}

