/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.plugin.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginA;
import com.ohaotian.abilitycommon.util.SpiLoadFactory;
import com.ohaotian.abilityweb.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityweb.mapper.AppMapper;
import com.ohaotian.abilityweb.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityweb.model.po.AppPO;
import com.ohaotian.abilityweb.service.plugin.CheckService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CheckServiceImpl
implements CheckService {
    private static final Logger logger = LogManager.getLogger(CheckServiceImpl.class);
    @Resource
    ApplicationContext applicationContext;
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private AbilityProvideDeployMapper abilityProvideDeployMapper;

    @Override
    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
            abilityProvideDeployPO.setAbilityId(msgContext.getEsbAbility().getAbilityId());
            abilityProvideDeployPO = this.abilityProvideDeployMapper.queryLimitOne(abilityProvideDeployPO);
            AppPO appPO = this.appMapper.queryByAppId(abilityProvideDeployPO.getAppId());
            AppBO appBo = new AppBO();
            BeanUtils.copyProperties((Object)appPO, (Object)appBo);
            msgContext.getSelfDefHeader().setApp(appBo);
            List loaders = SpiLoadFactory.loadFactories(PluginA.class);
            for (PluginA pluginA : loaders) {
                PluginA pluginAImpl = (PluginA)this.applicationContext.getBean(pluginA.getClass());
                pluginAImpl.doService(msgContext);
            }
        }
        catch (AbilityException e) {
            logger.warn(e.codeMsg.getRspDesc());
            throw new AbilityException(e.codeMsg, (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new AbilityException(CodeMsg.E_PLUGIN_NOT_IMPORT.fillArgs(new Object[]{":" + e.getMessage()}), (Throwable)e);
        }
    }
}

