/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.plugin.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RedisSyncDataBo;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginC;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityweb.mapper.PluginMapper;
import com.ohaotian.abilityweb.model.po.PluginPO;
import com.ohaotian.abilityweb.service.plugin.RouteService;
import com.ohaotian.atp.base.model.TokenRefreshBo;
import com.ohaotian.plugin.service.RoutePluginService;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class RouteServiceImpl
implements RouteService {
    private static final Logger log = LoggerFactory.getLogger(RouteServiceImpl.class);
    @Resource
    ApplicationContext applicationContext;
    @Resource
    PluginMapper pluginMapper;
    @Resource
    private PubSubRes pubSubRes;

    @Override
    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            if (Boolean.TRUE.equals(msgContext.getAbilityToVega().getToVega()) && Boolean.FALSE.equals(msgContext.getAbilityToVega().getDoAuth())) {
                log.info("{} \u5df2\u5f00\u542f\u8f6c\u53d1\uff0c\u8df3\u8fc7\u8def\u7531\u9274\u6743\u5c01\u88c5\uff01", (Object)msgContext.getEsbAbility().getAbilityEname());
                msgContext.getAbilityToVega().setReqData(msgContext.getTlogReqHeader().getReqData());
                msgContext.getTlogReqHeader().setReqObj(msgContext.getTlogReqHeader().getReqObj(msgContext));
                return;
            }
            if (Boolean.TRUE.equals(msgContext.getBodyListFlag())) {
                log.warn("JSONArray \u8df3\u8fc7\u8def\u7531\u5904\u7406\uff01");
                return;
            }
            List route = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "route".equals(bo.getPluginType())).collect(Collectors.toList());
            if (!route.isEmpty()) {
                PluginC routeImpl = (PluginC)this.applicationContext.getBean(RoutePluginService.class);
                routeImpl.doService(msgContext);
            }
            String regionCode = msgContext.getSelfDefHeader().getRegionBO().getRegionCode();
            PluginPO pluginPo = new PluginPO();
            pluginPo.setRegionCode(regionCode);
            List<PluginPO> pluginPoList = this.pluginMapper.queryByCond(pluginPo);
            if (ObjectUtils.isEmpty(pluginPoList)) {
                return;
            }
            String originalToken = this.getToken(msgContext, "token");
            if ((pluginPoList = pluginPoList.stream().filter(pluginPoTmp -> msgContext.getEsbAbility().getAbilityPluginBOList().stream().map(AbilityPluginBO::getPluginId).collect(Collectors.toList()).contains(pluginPoTmp.getPluginId())).collect(Collectors.toList())).size() > 1) {
                log.error("\u5f53\u524d\u80fd\u529b{} \u5728{}\u5206\u533a\u7ed1\u5b9a\u63d2\u4ef6\u4e0d\u552f\u4e00\uff0c\u62e5\u6709\u63d2\u4ef6:{}", new Object[]{msgContext.getEsbAbility().getAbilityEname(), regionCode, pluginPoList.stream().map(PluginPO::getPluginId).collect(Collectors.toList())});
                throw new AbilityException(CodeMsg.REGION_MULTI_PLUGIN.fillArgs(new Object[]{regionCode}));
            }
            boolean flag = Boolean.FALSE;
            for (PluginPO pluginData : pluginPoList) {
                String stringBuilder = pluginData.getPluginId() + "|" + pluginData.getPluginName() + "|" + pluginData.getPluginEname();
                log.info("\u63d2\u4ef6\u4fe1\u606f pluginPo ---> {}", (Object)stringBuilder);
                PluginC plugincImpl = (PluginC)this.applicationContext.getBean(pluginData.getPluginType());
                if (ObjectUtils.isEmpty((Object)plugincImpl)) continue;
                try {
                    plugincImpl.doService(msgContext);
                    flag = Boolean.FALSE;
                }
                catch (AbilityException e) {
                    CodeMsg codeMsg = e.codeMsg;
                    if (!"401".equals(codeMsg.getRspCode())) continue;
                    flag = Boolean.TRUE;
                }
            }
            try {
                String encapsulated = this.getToken(msgContext, "token");
                String orgId = this.getToken(msgContext, "orgId");
                TokenRefreshBo tokenRefreshBo = new TokenRefreshBo();
                tokenRefreshBo.setPluginIds(pluginPoList.stream().map(PluginPO::getPluginId).collect(Collectors.toList()));
                tokenRefreshBo.setOrgId(orgId);
                msgContext.setTokenRefreshBo(tokenRefreshBo);
                if ((originalToken.equals(encapsulated) || Boolean.TRUE.equals(flag)) && !CollectionUtils.isEmpty(pluginPoList)) {
                    RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
                    redisSyncDataBo.setCode("TOKEN_REFRESH");
                    redisSyncDataBo.setTokenRefreshBo(tokenRefreshBo);
                    log.warn("\u9274\u6743\u8865\u507f\u673a\u5236: token\u62fc\u63a5\u5f02\u5e38\uff0c\u5f02\u5e38\u63d2\u4ef6={}\uff0corgId={}", (Object)tokenRefreshBo.getPluginIds(), (Object)tokenRefreshBo.getOrgId());
                    this.pubSubRes.getClient().publish("", GsonUtil.toJson((Object)redisSyncDataBo));
                }
            }
            catch (Exception e) {
                log.warn("\u9274\u6743\u8865\u507f\u673a\u5236: token\u62fc\u63a5\u5f02\u5e38,\u8fd4\u56de\u6d88\u606f\u63a8\u9001\u5f02\u5e38\uff01 {}", (Object)e.getMessage());
            }
            if (Boolean.TRUE.equals(flag)) {
                throw new AbilityException(CodeMsg.REDIS_TOKEN_ERROR);
            }
        }
        catch (AbilityException e) {
            log.warn(e.codeMsg.getRspDesc());
            throw new AbilityException(e.codeMsg, (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new AbilityException(CodeMsg.E_PLUGIN_NOT_IMPORT.fillArgs(new Object[]{":" + e.getMessage()}), (Throwable)e);
        }
    }

    private String getToken(MsgContext msgContext, String key) {
        String reqData = new String(msgContext.getTlogReqHeader().getReqData(), StandardCharsets.UTF_8);
        JSONObject json = JSON.parseObject((String)reqData);
        Object tokenObj = json.get((Object)key);
        if (ObjectUtils.isEmpty((Object)tokenObj)) {
            return "";
        }
        return String.valueOf(tokenObj);
    }
}

