/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.token;

import com.alibaba.fastjson.JSONPath;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.DateUtil;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.enums.AppendEnum;
import com.ohaotian.abilityweb.enums.CallProtocolEnum;
import com.ohaotian.abilityweb.enums.TokenPositionEnum;
import com.ohaotian.abilityweb.service.token.TokenRefresh;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class TokenRefreshImpl
implements TokenRefresh {
    private static final Logger log = LoggerFactory.getLogger(TokenRefreshImpl.class);
    public static final String MARK = "_hpc";
    public static final String SPLICING_MARK = "_mhpc";
    public static final String CHPC = "chpc-";
    @Resource
    private CacheClient cacheClient;
    @Value(value="${jd.default.oigid:400000010000062675}")
    private String jdDefaultOrgid;
    @Value(value="${jd.default.param:orgId}")
    private String jdDefaultParam;

    @Override
    public void doRefresh(MsgContext msgContext) throws AbilityException {
        Date expiresIn;
        long duration;
        String token;
        if (!msgContext.getEsbAbility().getAbilityEname().contains(MARK)) {
            return;
        }
        String response = new String(msgContext.getTlogRspHeader().getRspData(), StandardCharsets.UTF_8);
        com.alibaba.fastjson.JSONObject respObj = com.alibaba.fastjson.JSONObject.parseObject((String)response);
        String request = new String(msgContext.getTlogReqHeader().getReqData(), StandardCharsets.UTF_8);
        com.alibaba.fastjson.JSONObject reqObj = com.alibaba.fastjson.JSONObject.parseObject((String)request);
        String tokenRule = reqObj.getString("tokenRule");
        String expiresRule = reqObj.getString("expiresRule");
        com.alibaba.fastjson.JSONObject tokenRsp = com.alibaba.fastjson.JSONObject.parseObject((String)response);
        if (StringUtils.isNotBlank((CharSequence)tokenRule)) {
            try {
                token = JSONPath.eval((Object)respObj, (String)tokenRule).toString();
            }
            catch (Exception e) {
                log.error("token\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5tokenRule!" + e.getMessage());
                throw new AbilityException("token\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5tokenRule!" + e.getMessage());
            }
        } else {
            token = ObjectUtils.isEmpty((Object)(tokenRsp = (com.alibaba.fastjson.JSONObject)tokenRsp.get((Object)"result")).getString("access_token")) ? tokenRsp.getString("Access_token") : tokenRsp.getString("access_token");
        }
        com.alibaba.fastjson.JSONObject expiresRsp = com.alibaba.fastjson.JSONObject.parseObject((String)response);
        if (StringUtils.isNotBlank((CharSequence)expiresRule)) {
            try {
                duration = Long.parseLong(JSONPath.eval((Object)respObj, (String)expiresRule).toString());
            }
            catch (Exception e) {
                log.error("expires\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5expiresRule!" + e.getMessage());
                throw new AbilityException("expires\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5tokenRule!" + e.getMessage());
            }
        } else {
            expiresRsp = (com.alibaba.fastjson.JSONObject)expiresRsp.get((Object)"result");
            duration = expiresRsp.getLong("expires_in");
        }
        Date time = new Date();
        Date date = duration > time.getTime() ? new Date(duration) : (expiresIn = new Date(time.getTime() + (TokenRefreshImpl.isNumeric(BigDecimal.valueOf((double)duration / 1000.0).toString()) ? duration : duration * 1000L)));
        long expire = duration > time.getTime() ? duration - time.getTime() : (TokenRefreshImpl.isNumeric(BigDecimal.valueOf((double)duration / 1000.0).toString()) ? duration : duration * 1000L);
        this.setRedis(reqObj, token, expire, msgContext.getSelfDefHeader().getUrl());
    }

    @Override
    public void doSplicing(MsgContext msgContext) throws AbilityException {
        try {
            if (!msgContext.getEsbAbility().getAbilityEname().contains(SPLICING_MARK)) {
                return;
            }
            String request = new String(msgContext.getTlogReqHeader().getReqData(), StandardCharsets.UTF_8);
            com.alibaba.fastjson.JSONObject reqObj = com.alibaba.fastjson.JSONObject.parseObject((String)request);
            AbilityRedisTokenDataBo redisKeyName = new AbilityRedisTokenDataBo();
            redisKeyName.setHsn(reqObj.getString("hsn"));
            redisKeyName.setOrgId(ObjectUtils.isEmpty((Object)reqObj.getString(this.jdDefaultOrgid)) ? this.jdDefaultOrgid : reqObj.getString(this.jdDefaultOrgid));
            String key = this.getRedisNodeName(redisKeyName);
            AbilityRedisTokenDataBo redisTokenDataBo = (AbilityRedisTokenDataBo)GsonUtil.fromJson((String)this.cacheClient.get(key).toString(), AbilityRedisTokenDataBo.class);
            if (ObjectUtils.isEmpty((Object)redisTokenDataBo)) {
                throw new AbilityException("web-Token\u63d2\u4ef6\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8c03\u7528token\uff01");
            }
            this.contentStitching(msgContext, redisTokenDataBo, redisTokenDataBo.getTokenPosition(), AppendEnum.TOKEN.getCode(), redisTokenDataBo.getToken());
            String appendAll = redisTokenDataBo.getAppends();
            if (StringUtils.isNotBlank((CharSequence)appendAll)) {
                String[] appends;
                for (String append : appends = appendAll.split(",")) {
                    String[] data = append.split("=>");
                    if (data.length != 3) {
                        throw new AbilityException("web token\u63d2\u4ef6\u914d\u7f6eAppends\u62fc\u63a5\u6709\u95ee\u9898\uff01");
                    }
                    this.contentStitching(msgContext, redisTokenDataBo, TokenPositionEnum.getEumByCode(data[1]).getValue(), data[0], data[2]);
                }
            }
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("web-token\u5f02\u5e38" + e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":web-token >>> web-token\u63d2\u4ef6\u5f02\u5e38:"}) + e.getMessage());
        }
    }

    private void contentStitching(MsgContext msgContext, AbilityRedisTokenDataBo redisTokenDataBo, Integer position, String fieldName, String fieldData) throws IOException {
        Integer callProtocol = redisTokenDataBo.getCallProtocol();
        HashMap reqMap = Maps.newHashMap();
        Map req = this.json2Map(new String(msgContext.getTlogReqHeader().getReqData(), StandardCharsets.UTF_8));
        reqMap.putAll(req);
        if (callProtocol % 2 == 0) {
            if (position.equals(TokenPositionEnum.BODY.getValue())) {
                reqMap.put(fieldName, fieldData);
                msgContext.getTlogReqHeader().setReqData(GsonUtil.toJson((Object)reqMap).getBytes(StandardCharsets.UTF_8));
            } else {
                msgContext.getSelfDefHeader().getSelfDefMap().put(fieldName, fieldData);
            }
        } else {
            if (position.equals(TokenPositionEnum.BODY.getValue())) {
                reqMap.put(fieldName, fieldData);
                msgContext.getTlogReqHeader().setReqData(TokenRefreshImpl.map2form(reqMap).getBytes(StandardCharsets.UTF_8));
            } else {
                msgContext.getTlogReqHeader().setReqData(TokenRefreshImpl.map2form(reqMap).getBytes(StandardCharsets.UTF_8));
                msgContext.getSelfDefHeader().getSelfDefMap().put(fieldName, fieldData);
            }
            msgContext.getSelfDefHeader().getSelfDefMap().put("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    private static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    private void setRedis(com.alibaba.fastjson.JSONObject reqObj, String token, long expiresIn, String url) {
        AbilityRedisTokenDataBo redisTokenDataBo = new AbilityRedisTokenDataBo();
        redisTokenDataBo.setClientId(reqObj.getString("client_id"));
        redisTokenDataBo.setClientSecret(reqObj.getString("client_secret"));
        redisTokenDataBo.setCallProtocol(CallProtocolEnum.getEumByCode(reqObj.getString("call_protocol")).getValue());
        redisTokenDataBo.setTokenPath(url);
        redisTokenDataBo.setToken(token);
        redisTokenDataBo.setTokenPosition(TokenPositionEnum.getEumByCode(reqObj.getString("token_position")).getValue());
        redisTokenDataBo.setTime(DateUtil.formatDateWithMS((Date)new Date()));
        redisTokenDataBo.setHsn(reqObj.getString("hsn"));
        String appendAll = reqObj.getString("appends");
        if (StringUtils.isNotBlank((CharSequence)appendAll)) {
            String[] appends = appendAll.split(",");
            ArrayList<String> stringList = new ArrayList<String>();
            for (String append : appends) {
                String[] data = append.split("=>");
                if (data.length != 3) {
                    throw new AbilityException("web token\u63d2\u4ef6\u914d\u7f6eAppends\u62fc\u63a5\u6709\u95ee\u9898\uff01");
                }
                if (ObjectUtils.isEmpty((Object)reqObj.getString(data[0]))) continue;
                stringList.add(data[2] + "=>" + data[1] + "=>" + reqObj.getString(data[0]));
            }
            redisTokenDataBo.setAppends(String.join((CharSequence)",", stringList));
        }
        redisTokenDataBo.setAccName(ObjectUtils.isEmpty((Object)reqObj.getString("acc_name")) ? "\u9ed8\u8ba4\u8d26\u6237" : reqObj.getString("acc_name"));
        redisTokenDataBo.setOrgId(ObjectUtils.isEmpty((Object)reqObj.getString(this.jdDefaultOrgid)) ? this.jdDefaultOrgid : reqObj.getString(this.jdDefaultOrgid));
        redisTokenDataBo.setCompanyName(ObjectUtils.isEmpty((Object)reqObj.getString("company_name")) ? "\u9ed8\u8ba4" + this.jdDefaultOrgid + "\u8d26\u6237" : reqObj.getString("company_name"));
        String key = this.getRedisNodeName(redisTokenDataBo);
        String value = GsonUtil.toJson((Object)redisTokenDataBo);
        this.cacheClient.set(key, (Object)value);
        this.cacheClient.expire(key, Integer.parseInt(String.valueOf(expiresIn / 1000L)));
    }

    private String getRedisNodeName(AbilityRedisTokenDataBo redisTokenDataBo) {
        return CHPC + redisTokenDataBo.getHsn() + (ObjectUtils.isEmpty((Object)redisTokenDataBo.getOrgId()) ? "" : "-" + redisTokenDataBo.getOrgId());
    }

    public static String map2form(Map map) {
        StringBuilder s = new StringBuilder(16);
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                s.append(k).append("=").append(JSONObject.fromObject((Object)v)).append("&");
            } else if (v instanceof List) {
                s.append(k).append("=").append(JSONArray.fromObject((Object)v)).append("&");
            } else {
                s.append(k).append("=").append(v).append("&");
            }
        });
        return s.toString().substring(0, s.length() - 1);
    }

    private Map json2Map(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.readValue(json, Map.class);
    }
}

