/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.transform.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.ParseUtil;
import com.ohaotian.abilityweb.model.po.AbilityTransPO;
import com.ohaotian.abilityweb.service.transform.TransFormService;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="transFormData")
public class TransFormDataServiceImpl
implements TransFormService {
    private static Logger logger = LogManager.getLogger(TransFormDataServiceImpl.class);

    @Override
    public void invokeTransFront(MsgContext msgContext) {
        logger.debug("\u8bf7\u6c42\u62a5\u6587\u8f6c\u6362");
        try {
            Object object = msgContext.getTlogReqHeader().getReqObj(msgContext);
            String template = msgContext.getEsbAbility().getFrontTemplate();
            String body = ParseUtil.doParse((Object)object, (String)template);
            msgContext.getTlogReqHeader().setReqData(body.getBytes(Consts.UTF_8));
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u62a5\u6587\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_TRANS_FRONT_ERROR);
        }
    }

    @Override
    public void invokeTransBack(MsgContext msgContext) {
        logger.debug("\u54cd\u5e94\u62a5\u6587\u8f6c\u6362");
        try {
            Object object = msgContext.getTlogRspHeader().getRspObj(msgContext);
            String template = msgContext.getEsbAbility().getBackTemplate();
            String body = ParseUtil.doParse((Object)object, (String)template);
            msgContext.getTlogRspHeader().setRspData(body.getBytes(Consts.UTF_8));
            msgContext.setRspText(new String(msgContext.getTlogRspHeader().getRspData(), Consts.UTF_8));
        }
        catch (Exception e) {
            logger.error("\u54cd\u5e94\u62a5\u6587\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_TRANS_BACK_ERROR);
        }
    }

    @Override
    public void deployEsbServiceReq(EsbAbility esbAbility, AbilityTransPO abilityTransPO) {
        esbAbility.setReqTransType(abilityTransPO.getReqTransType());
        esbAbility.setFrontTemplate(abilityTransPO.getFrontTemplate());
    }

    @Override
    public void deployEsbServiceRsp(EsbAbility esbAbility, AbilityTransPO abilityTransPO) {
        esbAbility.setRspTransType(abilityTransPO.getRspTransType());
        esbAbility.setBackTemplate(abilityTransPO.getBackTemplate());
    }
}

