/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.transform.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.js.MngHelperService;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilityweb.model.po.AbilityTransPO;
import com.ohaotian.abilityweb.service.transform.TransFormService;
import java.util.Objects;
import javax.script.ScriptException;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="transFormLogic")
public class TransFormLogicServiceImpl
implements TransFormService {
    private static Logger logger = LogManager.getLogger(TransFormLogicServiceImpl.class);
    @Autowired
    private MngHelperService mngHelperService;

    @Override
    public void invokeTransFront(MsgContext msgContext) {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        logger.debug("\u8c03\u7528\u524d\u62a5\u6587\u8f6c\u6362");
        TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
        msgContext.setReqText(new String(msgContext.getTlogReqHeader().getReqData(), Consts.UTF_8));
        try {
            Object o;
            String logic = esbAbility.getFrontLogic();
            if (!Objects.isNull(logic)) {
                String funName = esbAbility.getAbilityEname() + esbAbility.getAbilityVersion() + "frontFun";
                funName = funName.replace(".", "_");
                o = this.mngHelperService.eval(funName, logic, new Object[]{msgContext});
                if (!(o instanceof String)) {
                    logger.error("\u8fd4\u56de\u7c7b\u578b\u4e0d\u652f\u6301\u5904\u7406");
                    throw new AbilityException(CodeMsg.E_INVOKE_NO_SUPPORT);
                }
            } else {
                throw new AbilityException(CodeMsg.E_INVOKE_NO_LOGIC);
            }
            tlogReqHeader.setOldReqData(tlogReqHeader.getReqData());
            tlogReqHeader.setReqData(((String)o).getBytes(Consts.UTF_8));
            msgContext.setTlogReqHeader(tlogReqHeader);
        }
        catch (ScriptException e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{":\u6587\u4ef6" + e.getFileName() + "\u4e2d,\u7b2c" + e.getLineNumber() + "\u884c\uff0c\u7b2c" + e.getColumnNumber() + "\u4f4d,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()}));
        }
        catch (Exception e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    @Override
    public void invokeTransBack(MsgContext msgContext) {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        logger.debug("\u8c03\u7528\u540e\u62a5\u6587\u8f6c\u6362");
        TlogRspHeader tlogRspHeader = msgContext.getTlogRspHeader();
        msgContext.setRspText(new String(msgContext.getTlogRspHeader().getRspData(), Consts.UTF_8));
        try {
            Object o;
            String logic = esbAbility.getBackLogic();
            if (!Objects.isNull(logic)) {
                String funName = esbAbility.getAbilityEname() + esbAbility.getAbilityVersion() + "BackFun";
                funName = funName.replace(".", "_");
                msgContext.getTlogReqHeader().setReqObj(null);
                try {
                    msgContext.getTlogReqHeader().setReqObj(msgContext.getTlogReqHeader().getReqObj(msgContext));
                }
                catch (Exception e) {
                    String frontLogic = esbAbility.getFrontLogic();
                    if (!Objects.isNull(frontLogic)) {
                        logger.warn("\u4f7f\u7528\u4fee\u6539\u524d\u8bf7\u6c42\u62a5\u6587\u8fdb\u884c\u5904\u7406\uff01");
                        msgContext.getTlogReqHeader().setReqData(msgContext.getTlogReqHeader().getOldReqData());
                        msgContext.getTlogReqHeader().setReqObj(msgContext.getTlogReqHeader().getReqObj(msgContext));
                    }
                    e.printStackTrace();
                }
                o = this.mngHelperService.eval(funName, logic, new Object[]{msgContext});
                if (!(o instanceof String)) {
                    logger.error("\u8fd4\u56de\u7c7b\u578b\u4e0d\u652f\u6301\u5904\u7406");
                    throw new AbilityException(CodeMsg.E_INVOKE_NO_SUPPORT);
                }
            } else {
                throw new AbilityException(CodeMsg.E_INVOKE_NO_LOGIC);
            }
            tlogRspHeader.setRspData(((String)o).getBytes(msgContext.getRspStringEncoding()));
            msgContext.setTlogRspHeader(tlogRspHeader);
        }
        catch (ScriptException e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{":\u6587\u4ef6" + e.getFileName() + "\u4e2d,\u7b2c" + e.getLineNumber() + "\u884c\uff0c\u7b2c" + e.getColumnNumber() + "\u4f4d,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()}));
        }
        catch (Exception e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    @Override
    public void deployEsbServiceReq(EsbAbility esbAbility, AbilityTransPO abilityTransPO) {
        esbAbility.setReqTransType(abilityTransPO.getReqTransType());
        esbAbility.setFrontLogic(abilityTransPO.getFrontLogic());
    }

    @Override
    public void deployEsbServiceRsp(EsbAbility esbAbility, AbilityTransPO abilityTransPO) {
        esbAbility.setRspTransType(abilityTransPO.getRspTransType());
        esbAbility.setBackLogic(abilityTransPO.getBackLogic());
    }
}

