/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.application.bo.ApplicationBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.logger.bo.SaveLoginLogReqBO;
import com.ohaotian.authority.logger.service.SaveLoginLogBusiService;
import com.ohaotian.authority.login.bo.LoginExpTimeReqBO;
import com.ohaotian.authority.login.service.LoginService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameReqBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.IPUtils;
import com.ohaotian.plugin.security.entity.LoginReqBO;
import com.ohaotian.plugin.security.entity.MenuInfo;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.jwt.Jwt;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import com.ohaotian.plugin.security.utils.UserAgent;
import com.ohaotian.plugin.security.utils.UserAgentUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PermissionsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionsController.class);
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectTenantByIdService selectTenantByIdService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SaveLoginLogBusiService saveLoginLogBusiService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private LoginService loginService;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.loginNum:3}")
    private Integer loginNum;
    @Value(value="${login.lockTime:86400}")
    private int loginLockTime;

    @RequestMapping(value={"/auth/getUserMenus"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserMenus(@RequestParam(required=false) String appCode) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            LOGGER.debug("getUserMenus" + appCode);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appCode})) {
                Map<String, List<MenuInfo>> menus = user.getMenus();
                SelectByApplicationCodeReqBO selectByApplicationCodeReqBO = new SelectByApplicationCodeReqBO();
                selectByApplicationCodeReqBO.setApplicationCode(appCode);
                SelectByApplicationCodeRspBO application = this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
                map.put("menus", menus.get(appCode));
                if (application != null) {
                    map.put("appName", application.getApplicationBO().getApplicationName());
                }
            } else {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setUserId(user.getUserId());
                applicationByUserReqBO.setOrgPath(user.getOrgPath());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                if (applicationBOS != null && applicationBOS.size() > 0) {
                    ApplicationBO applicationBO = (ApplicationBO)applicationBOS.get(0);
                    map.put("appName", applicationBO.getApplicationName());
                    map.put("isExt", applicationBO.getIsExt());
                    appCode = applicationBO.getApplicationCode();
                    Map<String, List<MenuInfo>> menus = user.getMenus();
                    map.put("menus", menus.get(appCode));
                }
            }
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/havePerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object havePerms(@RequestParam String[] authority) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String auth : authority) {
                map.put(auth, user.hasAuthority(auth));
            }
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserPerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserPerms() {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashSet permission = new HashSet();
            user.getPermission().forEach(perm -> permission.add(perm.getKey()));
            return permission;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        LOGGER.debug(JSON.toJSONString((Object)userInfo));
        if (userInfo != null) {
            UserInfo result = new UserInfo();
            BeanUtils.copyProperties((Object)userInfo, (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result.getCellphone()) && result.getCellphone().length() == 11) {
                String start = result.getCellphone().substring(0, 3);
                String end = result.getCellphone().substring(8, 11);
                String temp = "*****";
                result.setCellphone(start + temp + end);
            }
            return result;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    @RequestMapping(value={"/auth/getFullUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getFullUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            return userInfo;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/auth/users/signup/login"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object getToken(HttpServletRequest request, @RequestBody LoginReqBO reqBO) {
        Date date;
        HashMap<String, Object> payload;
        block14: {
            block13: {
                UserInfo rspBO = new UserInfo();
                payload = new HashMap<String, Object>();
                date = new Date();
                UserInfo userInfo = new UserInfo();
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getLoginName()}) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getPassWord()})) break block13;
                Integer num = (Integer)this.cacheService.get("cas" + reqBO.getLoginName());
                if (num != null && num.equals(this.loginNum)) {
                    throw new ZTBusinessException("\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u7981\u6b62\u5f53\u524d\u7528\u6237\u767b\u5f55");
                }
                if (num == null) {
                    num = 0;
                }
                SelectUserByLoginNameReqBO selectUserByLoginNameReqBO = new SelectUserByLoginNameReqBO();
                selectUserByLoginNameReqBO.setUsername(reqBO.getLoginName());
                selectUserByLoginNameReqBO.setPassword(reqBO.getPassWord());
                selectUserByLoginNameReqBO.setType(null);
                SelectUserByLoginNameRspBO rspUser = this.selectUserByLoginNameService.selectUserByLoginNameService(selectUserByLoginNameReqBO);
                if (rspUser != null) {
                    payload.put("userId", rspUser.getUserId());
                    BeanUtils.copyProperties((Object)rspBO, (Object)userInfo);
                    userInfo.setUsername(rspUser.getLoginName());
                    if (rspUser.getStatus() == 1) {
                        throw new ZTBusinessException("\u7528\u6237\u72b6\u6001\u65e0\u6548\uff0c\u65e0\u6cd5\u767b\u9646\uff01");
                    }
                    Long userId = rspUser.getUserId();
                    if (rspUser.getTenantId() != null) {
                        TenantIdBO tenantIdBO = new TenantIdBO();
                        tenantIdBO.setTenantId(rspUser.getTenantId());
                        TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                        if (tenantRspBO != null && tenantRspBO.getStatus() != 0) {
                            throw new ZTBusinessException("\u7528\u6237\u6240\u5c5e\u79df\u6237\u65e0\u6548\uff0c\u65e0\u6cd5\u767b\u9646\uff01");
                        }
                    }
                    if (rspUser.getOrgId() != null) {
                        OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
                        organisationIdReqBO.setOrganisationId(rspUser.getOrgId());
                        RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
                        if (organisationBO != null && organisationBO.getStatus() != 0) {
                            throw new ZTBusinessException("\u7528\u6237\u6240\u5c5e\u673a\u6784\u65e0\u6548\uff0c\u65e0\u6cd5\u767b\u9646\uff01");
                        }
                    }
                    try {
                        SaveLoginLogReqBO loginLogReqBO = new SaveLoginLogReqBO();
                        loginLogReqBO.setLoginName(rspUser.getLoginName());
                        String agent = request.getHeader("user-agent");
                        UserAgent userAgent = UserAgentUtil.getUserAgent(agent);
                        loginLogReqBO.setMacOs(userAgent.getPlatformType());
                        loginLogReqBO.setBrowser(userAgent.getBrowserType());
                        String ip = IPUtils.getIp((HttpServletRequest)request);
                        loginLogReqBO.setHost(ip);
                        loginLogReqBO.setTenantId(rspUser.getTenantId());
                        this.saveLoginLogBusiService.saveLoginLog(loginLogReqBO);
                        loginLogReqBO.setMacInfo("\u767b\u5f55\u6210\u529f");
                    }
                    catch (Exception e) {
                        LOGGER.error("\u8bb0\u5f55\u767b\u5f55\u65e5\u5fd7\u9519\u8bef\u4fe1\u606f", (Throwable)e);
                    }
                    this.cacheService.delete("cas" + reqBO.getLoginName());
                    break block14;
                } else {
                    String errorMessage;
                    num = num + 1;
                    this.cacheService.set("cas" + reqBO.getLoginName(), (Object)num, this.loginLockTime);
                    Integer residualTimes = this.loginNum - num;
                    if (residualTimes > 0) {
                        errorMessage = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + residualTimes + "\u6b21\u673a\u4f1a\uff01";
                        throw new ZTBusinessException(errorMessage);
                    }
                    errorMessage = "\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u7981\u6b62\u5f53\u524d\u7528\u6237\u767b\u5f55";
                    throw new ZTBusinessException(errorMessage);
                }
            }
            if (reqBO.getUserId() == null) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            if (reqBO.getUserId() == 0L) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            payload.put("userId", reqBO.getUserId());
        }
        payload.put("iat", date.getTime());
        String token = Jwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        LoginExpTimeReqBO abilityReq = new LoginExpTimeReqBO();
        abilityReq.setToken(token);
        this.loginService.updateLoginExpTime(abilityReq);
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("token", token);
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }

    @RequestMapping(value={"/auth/users/signup/logout"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object logout(HttpServletRequest request, @RequestBody LoginExpTimeReqBO reqBO) {
        String token = request.getHeader("auth-token");
        LoginExpTimeReqBO Req = new LoginExpTimeReqBO();
        Req.setToken(token);
        return this.loginService.logOut(Req);
    }
}

