/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.service.impl;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.menu.bo.AccessMenu;
import com.ohaotian.authority.menu.bo.SelectAccessMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAccessMenuRspBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuRspBO;
import com.ohaotian.authority.menu.service.SelectAccessMenuService;
import com.ohaotian.authority.menu.service.SelectAuthoritysMenuService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysReqBO;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysRspBO;
import com.ohaotian.authority.role.service.SelectRoleAuthoritysService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.ListUtils;
import com.ohaotian.plugin.security.entity.AuthorityInfo;
import com.ohaotian.plugin.security.entity.MenuInfo;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.service.GetUserInfoByUserIdService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class GetUserInfoByUserIdServiceImpl
implements GetUserInfoByUserIdService {
    private final Logger logger = LoggerFactory.getLogger(GetUserInfoByUserIdServiceImpl.class);
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectUserInfoService selectUserInfoService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectTenantByIdService selectTenantByIdService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectRoleAuthoritysService selectRoleAuthoritysService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectAuthoritysMenuService selectAuthoritysMenuService;
    @Reference(version="1.0.0", group="AUTH_GROUP_DEV", validation="true")
    private SelectAccessMenuService selectAccessMenuService;
    @Autowired
    private CacheClient cacheTemplate;

    @Override
    public UserDetails getUserInfoByUserId(Long userId, String token, String appCode) {
        try {
            String o = (String)this.cacheTemplate.get(token);
            UserInfo uInfo = (UserInfo)JSONObject.parseObject((String)o, UserInfo.class);
            if (o != null) {
                return uInfo;
            }
            UserInfo userInfo = this.loadUserInfo(userId);
            if (userInfo == null) {
                UserInfo finalUserInfo = new UserInfo();
                finalUserInfo.setUserId(userId);
                return finalUserInfo;
            }
            long startTime = System.currentTimeMillis();
            ExecutorService exec = Executors.newCachedThreadPool();
            CountDownLatch countDownLatch = new CountDownLatch(2);
            exec.execute(() -> {
                try {
                    this.loadUserMenus(userInfo, appCode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            exec.execute(() -> {
                this.loadUserAuthoritys(userInfo, appCode);
                countDownLatch.countDown();
            });
            countDownLatch.await();
            exec.shutdown();
            long endTime = System.currentTimeMillis();
            System.out.println("\u83b7\u53d6\u6743\u9650\u8fd0\u884c\u65f6\u95f4\uff1a " + (endTime - startTime) + "ms");
            if (null != userInfo) {
                this.cacheTemplate.set(token, (Object)JSONObject.toJSONString((Object)userInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}));
            }
            return userInfo;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u6743\u9650\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private UserInfo loadUserInfo(Long userId) {
        UserInfo userInfo = new UserInfo();
        SelectUserInfoReqBO userInfoReqBO = new SelectUserInfoReqBO();
        userInfoReqBO.setUserId(userId);
        SelectUserInfoRspBO rspUser = this.selectUserInfoService.selectUserInfo(userInfoReqBO);
        if (rspUser != null) {
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getName());
            userInfo.setUsername(rspUser.getLoginName());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setCellphone(rspUser.getCellPhone());
            if (rspUser.getTenantId() != null) {
                TenantIdBO tenantIdBO = new TenantIdBO();
                tenantIdBO.setTenantId(rspUser.getTenantId());
                TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                userInfo.setTenantId(tenantRspBO.getTenantId());
                userInfo.setTenantName(tenantRspBO.getTenantName());
            }
            if (userInfo.getOrgId() != null) {
                OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
                organisationIdReqBO.setOrganisationId(userInfo.getOrgId());
                RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
                if (organisationBO != null) {
                    userInfo.setOrgPath(organisationBO.getOrgTreePath());
                    userInfo.setOrgName(organisationBO.getTitle());
                }
            }
        }
        return userInfo;
    }

    private void loadUserMenus(UserInfo userInfo, String appCode) throws Exception {
        SelectAccessMenuReqBO menuReqBO = new SelectAccessMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        menuReqBO.setApplicationCode(appCode);
        SelectAccessMenuRspBO menuRspBO = this.selectAccessMenuService.selectAccessMenuService(menuReqBO);
        List menuList = menuRspBO.getAccessMenuList();
        if (menuList != null && menuList.size() > 0) {
            for (AccessMenu menu : menuList) {
                if (!StringUtils.isNotBlank((CharSequence)menu.getMenuDomain())) continue;
                menu.setDomain(menu.getMenuDomain());
            }
            List unMenuInfos = ListUtils.copyListProperties((List)menuList, MenuInfo.class);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appCode})) {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setOrgPath(userInfo.getOrgPath());
                applicationByUserReqBO.setUserId(userInfo.getUserId());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                applicationBOS.forEach(a -> {
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{a.getApplicationCode()}) && a.getApplicationCode().equals(appCode) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getUrl()})) {
                        MenuInfo m = new MenuInfo();
                        m.setUrl(a.getUrl());
                        unMenuInfos.add(m);
                    }
                });
            }
            MenuInfo m = new MenuInfo();
            m.setUrl("/index.html");
            unMenuInfos.add(m);
            MenuInfo m1 = new MenuInfo();
            m1.setUrl("/rest/**");
            unMenuInfos.add(m1);
            userInfo.setUnstructuredMunes(unMenuInfos);
            HashMap<String, List<MenuInfo>> menuMap = new HashMap<String, List<MenuInfo>>();
            Map<String, List<AccessMenu>> menuListMap = this.groupBillingDataByAppCode(menuList);
            menuListMap.keySet().forEach(key -> {
                List accessMenus = (List)menuListMap.get(key);
                List menuInfos = ListUtils.copyListProperties((List)accessMenus, MenuInfo.class);
                if (menuInfos.size() > 0) {
                    List<MenuInfo> buildByRecursive = this.buildByRecursive(menuInfos);
                    menuMap.put((String)key, buildByRecursive);
                }
            });
            userInfo.setMenus(menuMap);
        }
    }

    private List<MenuInfo> buildByRecursive(List<MenuInfo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<MenuInfo> trees = new ArrayList<MenuInfo>();
        for (MenuInfo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private MenuInfo findChildren(MenuInfo root, List<MenuInfo> allMenus) {
        for (MenuInfo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getSubMenus() == null) {
                root.setSubMenus(new ArrayList<MenuInfo>());
            }
            root.getSubMenus().add(this.findChildren(it, allMenus));
        }
        return root;
    }

    private void loadUserAuthoritys(UserInfo userInfo, String appCode) {
        HashSet<AuthorityInfo> authorities = new HashSet<AuthorityInfo>();
        SelectAuthoritysMenuReqBO menuReqBO = new SelectAuthoritysMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setApplicationCode(appCode);
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectAuthoritysMenuRspBO authoritysMenuRspBO = this.selectAuthoritysMenuService.selectAuthoritysMenuService(menuReqBO);
        List authorityMenuList = authoritysMenuRspBO.getAuthorityMenuList();
        if (authorityMenuList != null && authorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)authorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
        }
        SelectRoleAuthoritysReqBO roleAuthoritysReqBO = new SelectRoleAuthoritysReqBO();
        roleAuthoritysReqBO.setUserId(userInfo.getUserId());
        roleAuthoritysReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectRoleAuthoritysRspBO roleAuthoritysRspBO = this.selectRoleAuthoritysService.selectRoleAuthoritysService(roleAuthoritysReqBO);
        List roleAuthoritysRspBOAuthorityMenuList = roleAuthoritysRspBO.getAuthorityMenuList();
        if (roleAuthoritysRspBOAuthorityMenuList != null && roleAuthoritysRspBOAuthorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)roleAuthoritysRspBOAuthorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
        }
        userInfo.setPermission(authorities);
    }

    private Map<String, List<AccessMenu>> groupBillingDataByAppCode(List<AccessMenu> billingList) throws Exception {
        HashMap<String, List<AccessMenu>> resultMap = new HashMap<String, List<AccessMenu>>();
        try {
            for (AccessMenu accessMenu : billingList) {
                if (resultMap.containsKey(accessMenu.getAppCode())) {
                    ((List)resultMap.get(accessMenu.getAppCode())).add(accessMenu);
                    continue;
                }
                ArrayList<AccessMenu> tmpList = new ArrayList<AccessMenu>();
                tmpList.add(accessMenu);
                resultMap.put(accessMenu.getAppCode(), tmpList);
            }
        }
        catch (Exception e) {
            throw new Exception("\u6309\u7167\u5b50\u7cfb\u7edf\u7f16\u7801\u5bf9\u83dc\u5355\u6570\u636e\u8fdb\u884c\u5206\u7ec4\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
        return resultMap;
    }
}

