/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.authority.login.bo.LoginExpTimeReqBO;
import com.ohaotian.authority.login.bo.LoginExpTimeRspBO;
import com.ohaotian.authority.login.service.LoginService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.filter.ParameterRequestWrapper;
import com.ohaotian.plugin.security.jwt.Jwt;
import com.ohaotian.plugin.security.jwt.TokenState;
import com.ohaotian.plugin.security.service.GetUserInfoByUserIdService;
import com.ohaotian.plugin.security.utils.RegexUtils;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.GenericFilterBean;

public class TokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationFilter.class);
    @Value(value="${static.resources}")
    private String staticResources;
    @Value(value="${login.expTime:7200}")
    private Long expTime;
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private GetUserInfoByUserIdService getUserInfoByTokenService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private LoginService loginService;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String token = request.getHeader("auth-token");
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject datajsonObject = new com.alibaba.fastjson.JSONObject();
        LOGGER.debug("\u83b7\u53d6\u5f53\u524dtocken" + token);
        if (!StringUtils.isEmpty((CharSequence)token)) {
            LoginExpTimeReqBO reqBO = new LoginExpTimeReqBO();
            reqBO.setToken(token);
            LoginExpTimeRspBO rspBO = this.loginService.getLoginExpTime(reqBO);
            Long loginExpTime = 0L;
            LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1" + JSON.toJSONString((Object)rspBO));
            if ("0".equals(rspBO.getCode())) {
                loginExpTime = rspBO.getExpTime();
                LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
            }
            if (loginExpTime != null) {
                Date date = new Date(loginExpTime);
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                LOGGER.debug(sd.format(date));
            }
            Map<String, Object> resultMap = Jwt.validToken(token, loginExpTime);
            TokenState state = TokenState.getTokenState((String)resultMap.get("state"));
            switch (state) {
                case VALID: {
                    JSONObject data = (JSONObject)resultMap.get("data");
                    request.setAttribute("data", (Object)data);
                    String appCode = data.getAsString("appCode");
                    this.loginService.updateLoginExpTime(reqBO);
                    UserDetails user = this.getUserInfoByTokenService.getUserInfoByUserId((Long)data.get((Object)"userId"), token, appCode);
                    return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
                }
                case EXPIRED: {
                    datajsonObject.put("respCode", (Object)"AE401");
                    datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)datajsonObject);
                    break;
                }
                default: {
                    datajsonObject.put("respCode", (Object)"AE401");
                    datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)datajsonObject);
                    break;
                }
            }
        } else {
            datajsonObject.put("respCode", (Object)"AE401");
            datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            jsonObject.put("data", (Object)datajsonObject);
        }
        response.setStatus(401);
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("code", (Object)"1");
        jsonObject.put("message", (Object)"\u5931\u8d25");
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletRequest requestWrapper = null;
        String url = request.getRequestURI();
        boolean needToken = true;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.staticResources})) {
            String[] split;
            for (String staticResource : split = this.staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", url)) {
            needToken = false;
        }
        allowSessionCreation.set(true);
        if (needToken) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
            requestWrapper = this.parameterRequest(request.getHeader("auth-token"), request, response);
        }
        if (requestWrapper == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            LOGGER.debug("UserInfoWrapperFilter---1\uff1a");
        } else {
            LOGGER.debug("UserInfoWrapperFilter---2\uff1a");
            chain.doFilter(requestWrapper, (ServletResponse)response);
        }
    }

    private ServletRequest parameterRequest(String token, HttpServletRequest request, HttpServletResponse response) {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        ParameterRequestWrapper requestWrapper = null;
        if (userInfo != null && userInfo.getUserId() != null && request instanceof HttpServletRequest) {
            LOGGER.debug("UserInfoWrapperFilter---\u81ea\u5b9a\u4e49\u5305\u88c5\u5668\uff1a");
            requestWrapper = new ParameterRequestWrapper(request);
        }
        LOGGER.debug("UserInfoWrapperFilter---requestWrapper\uff1a");
        return requestWrapper;
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

