package com.ohaotian.plugin.mq.proxy.internal;

import com.ohaotian.plugin.mq.proxy.ProxyMessageType;

import java.util.Properties;

/**
 * 标题：消息配置接口
 * <p>
 * 说明：消息配置接口
 * <br>
 * 时间：2018/06/26<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public interface ProxyMessageConfig {
    /**
     * 获取 主题
     *
     * @return 主题
     */
    String getSubject();

    /**
     * 获取 标签
     *
     * @return 标签
     */
    String[] getTags();

    /**
     * 支持的消息类型
     *
     * @return 消息类型
     */
    ProxyMessageType[] supportMessageTypes();

    /**
     * 获取 消息策略
     *
     * @return 消息策略
     */
    String getStrategy();

    /**
     * 获取 属性
     *
     * @return 属性
     */
    Properties getProperties();
}
