package com.ohaotian.plugin.mq.proxy.callback;

import com.ohaotian.plugin.mq.proxy.ProxyExceptionContext;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;

/**
 * 标题：异步消息回调对象接口
 * <p>
 * 说明：发送异步消息时，需要传入该接口实现类的实例
 * <br>
 * 时间：2018/06/26<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public interface ProxySendCallback {
    /**
     * 消息发送成功时触发
     *
     * @param result 发送结果
     */
    void onSuccess(ProxySendResult result);

    /**
     * 消息发送异常时触发
     *
     * @param exceptionContext 异常信息
     */
    void onException(ProxyExceptionContext exceptionContext);
}
