package com.ohaotian.plugin.actuator.web;

import com.google.common.collect.ImmutableMultimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

/**
 * Use HSF:
 *
 * @Resource DemoPropertyService demoPropertyService;
 * @RequestMapping public Map getAllProperty() {
 * Map properties = demoPropertyService.getAllProperty();
 * return properties;
 * }
 */
@RestController
@RequestMapping("/demo/props")
public class DemoPropertiesController {

    Logger logger = LoggerFactory.getLogger(DemoPropertiesController.class);

    @Resource
    Properties propertiesFileLoader;

    @RequestMapping
    public Object getAllProperty() {

        if (null == propertiesFileLoader && propertiesFileLoader.isEmpty()) {
            return ImmutableMultimap.of("message", "propertiesFileLoader is null");
        }

        Map map = new TreeMap();
        propertiesFileLoader.entrySet().stream().forEach(e -> map.put(e.getKey(), e.getValue()));
        return map;
    }
}