package com.ohaotian.plugin.base.exception;


import com.ohaotian.plugin.base.exception.strategy.ExceptionStrategy;

/**
 * @author liubq
 * @Description: 业务异常
 * <p>
 * 2018-11-29 增加消息参数作为RuntimeException 的message值 ,解决泛化调用时,取不到message 的问题
 */
public class ZTBusinessException extends ExceptionStrategy {
	private static final long serialVersionUID = 1L;

	private String msg;

	public ZTBusinessException() {
	}

	public ZTBusinessException(String msg) {
		super(msg);
		this.msg = msg;
	}

	@Override
	public String resolverException() {
		return msg;
	}

}