/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.base.filter;

import com.ohaotian.plugin.base.filter.EmojiFilteringHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;

public class EmojiFilteringBodyFilter
implements Filter {
    @Value(value="${security.xss.emoji:[\\ud83c\\udc00-\\ud83c\\udfff]|[\\ud83d\\udc00-\\ud83d\\udfff]|[\\u2600-\\u27ff]}")
    private String securityXssEmoji;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if ("POST".equalsIgnoreCase(httpRequest.getMethod())) {
            try {
                EmojiFilteringHttpServletRequestWrapper requestWrapper = new EmojiFilteringHttpServletRequestWrapper(httpRequest, this.securityXssEmoji);
                chain.doFilter((ServletRequest)requestWrapper, response);
            }
            catch (IOException e) {
                throw new ServletException("Error reading request body", (Throwable)e);
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

