package com.ohaotian.plugin.cache;

import redis.clients.jedis.JedisPool;

import java.util.Map;
import java.util.Set;

/**
 * 该接口名称有歧义，请使用新的CacheClient。
 *
 * <br>
 * 标题: 通用缓存接口<br>
 * 描述: 提供基本的get、set、delete方法<br>
 * 公司: www.chinaunicom.com<br>
 *
 * @autho liuce
 * @time 2016-7-18 下午1:06:30
 */
@Deprecated
public interface CacheService {

    /**
     * 往缓存中存放值（永不过期）<br>
     * 适用场景: 需要常驻缓存中的数据<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param value
     * @return
     * @autho liuce
     * @time 2016-7-18 下午1:21:38
     */
    void set(String key, Object value);

    /**
     * 该方法废弃，建议使用set(String key, Object value)
     *
     * 往缓存中存放值（永不过期）<br>
     * 适用场景: 需要常驻缓存中的数据<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param value
     * @return
     * @autho liuce
     * @time 2016-7-18 下午1:21:38
     */
    @Deprecated
    void put(String key, Object value);

    /**
     * 往缓存中存放值（一段时间内有效）<br>
     * 适用场景: 需要常驻缓存中的数据<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param value
     * @param expire 失效时间，0表示用不失效, 单位为秒。
     * @return
     * @autho liuce
     * @time 2016-7-18 下午1:21:38
     */
    void set(String key, Object value, int expire);

    /**
     * 该方法废弃，建议使用 set(String key, Object value, int expire)
     *
     * 往缓存中存放值（一段时间内有效）<br>
     * 适用场景: 需要常驻缓存中的数据<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param value
     * @param expire 失效时间，0表示用不失效
     * @return
     * @autho liuce
     * @time 2016-7-18 下午1:21:38
     */
    @Deprecated
    void put(String key, Object value, int expire);

    /**
     * 从缓存中获取值<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016-7-18 下午1:22:59
     */
    Object get(String key);

    /**
     * 从缓存中获取指定类型的结果<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param requiredType
     * @return
     * @autho liuce
     * @time 2016年9月9日 下午3:15:49
     */
    <T> T get(String key, Class<T> requiredType);

    /**
     * 从缓存中删除指定的key<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @autho liuce
     * @time 2016-7-18 下午1:23:43
     */
    void delete(String key);

    /**
     * 穿透查询<br>
     * 适用场景: <br>
     * 调用方式: 同步HSF方式调用<br>
     * 业务逻辑说明<br>
     * 做穿透查询，缓存中查询不到的数据通过本地查询执行器回调改执行器得到数据，最后放入缓存
     *
     * @param <T>
     * @param executer 本地查询执行器
     * @param key      支持多个参数，以多个String参数连接作为key
     * @return
     * @autho liuce
     * @time 2016-7-27 下午1:55:13
     */
    <T> T getFinal(CacheExecuterService<T> executer, String... key);

    /**
     * 根据表达式获取前缀一样的Key集合<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param pattern
     * @return
     * @autho liuce
     * @time 2016年9月25日 下午3:11:59
     */
    Set<String> getkeys(String pattern);

    /**
     * 获取key的失效时间<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年11月9日 上午12:10:41
     */
    Long getExpireTimeByKey(String key);

    /**
     * redis计数器，没有失效时间的<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:42:39
     */
    Long incr(String key);

    /**
     * redis计数器，有失效时间<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param expire
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:43:16
     */
    Long incrExpireTime(String key, int expire);

    /**
     * redis计数器，没有失效时间的<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:42:39
     */
    Long incrBy(String key, long num);

    /**
     * redis计数器，有失效时间<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param expire
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:43:16
     */
    Long incrExpireTimeBy(String key, long num, int expire);

    /**
     * 获取计数器的值<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午4:11:41
     */
    Long getIncr(String key);

    //队列操作 begin

    /**
     * <p>通过key向list尾部添加字符串</p>
     *
     * @param key
     * @param objs 可以使一个string 也可以使string数组
     * @return 返回list的value个数
     */
    Long rpush(String key, String objs);

    /**
     * <p>通过key从list的头部删除一个value,并返回该value</p>
     *
     * @param key
     * @return
     */
    String lpop(String key);


    /**
     * <p>通过key返回list的长度.
     * LLEN命令将返回存储在key列表的长度。如果key不存在，它被解释为一个空列表，则返回0。当存储在关key的值不是一个列表，则会返回错误。</p>
     *
     * @param key
     * @return
     */
    Long llen(String key);
    //队列操作 end

    //锁定操作 begin

    /**
     * 将 key 的值设为 value ，当且仅当 key 不存在。
     * 若给定的 key 已经存在，则 SETNX 不做任何动作。
     * SETNX 是『SET if Not eXists』(如果不存在，则 SET)的简写
     *
     * @param key
     * @return 返回值：设置成功，返回 1 。设置失败，返回 0 。
     */
    Long setnx(String key, Object value);

    /**
     * 语法：
     * GETSET key value
     * 功能：
     * 将给定 key 的值设为 value ，并返回 key 的旧值 (old value)，当 key 存在但不是字符串类型时，返回一个错误，当key不存在时，返回nil。
     */
    Object getSet(String key, Object value);

    //锁定操作 end

    /**
     * 获取Redis链接池
     * @return Redis链接池
     */
    JedisPool getJedisPool();

    /** <br>
     * 适用场景: 获取组合服务响应码<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param executor
     * @param key
     * @return
     * @autho QIJIANFEI
     * @time 2017年8月4日 下午8:52:35 */
    @Deprecated
    Map<String, String> getOuterCodeByKey(CacheExecuterService<Map<String, String>> executor, String... key);

    /** <br>
     * 适用场景:获取业务服务响应码 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param executor
     * @param key
     * @return
     * @autho QIJIANFEI
     * @time 2017年8月4日 下午8:52:59 */
    @Deprecated
    Map<String, String> getInnerCodeByKey(CacheExecuterService<Map<String, String>> executor, String... key);

    /**
     * Set cache manager.
     *
     * @param cacheManager
     */
    void setCacheManager(CacheManager cacheManager);
}

