/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.cache.RedisClusterManager;
import com.ohaotian.plugin.cache.RedisManager;
import com.ohaotian.plugin.cache.config.ClusterOrNot;
import com.ohaotian.plugin.cache.config.SignleOrNot;
import com.ohaotian.plugin.cache.impl.CacheClientImpl;
import com.ohaotian.plugin.common.util.RSAUtil;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class PluginCacheConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginCacheConfig.class);
    @Value(value="${redis.host}")
    private String host;
    @Value(value="${redis.port}")
    private int port;
    @Value(value="${redis.timeout}")
    private int timeout;
    @Value(value="${redis.pwd:}")
    private String pwd;
    @Value(value="${redis.pwd.publicKey:}")
    private String publicKey;
    @Value(value="${redis.database:0}")
    private int database;
    @Value(value="${redis.soTimeOut:2000}")
    private int soTimeOut;
    @Value(value="${redis.maxAttemts:5}")
    private int maxAttemts;
    @Value(value="${redis.pool.maxTotal}")
    private int poolMaxTotal;
    @Value(value="${redis.pool.maxIdle}")
    private int poolMaxIdle;
    @Value(value="${redis.pool.maxWaitMillis}")
    private int poolMaxWaitMillis;
    @Value(value="${redis.pool.testOnBorrow:false}")
    private boolean poolTestOnBorrow;
    @Value(value="${redis.pool.testOnReturn:false}")
    private boolean poolTestOnReturn;

    public void encrypt() {
        if (StringUtils.isNotEmpty((CharSequence)this.publicKey)) {
            try {
                logger.info("redis\u5bc6\u7801\u542f\u7528\u52a0\u5bc6\uff01");
                this.pwd = RSAUtil.decrypt((String)this.publicKey, (String)this.pwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            RSAUtil.genKeyPair((String)"123abcd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bean
    @Primary
    public JedisPoolConfig jedisPoolConfig() {
        this.printRedisConfig();
        this.encrypt();
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.poolMaxTotal);
        config.setMaxIdle(this.poolMaxIdle);
        config.setMaxWaitMillis((long)this.poolMaxWaitMillis);
        config.setTestOnBorrow(this.poolTestOnBorrow);
        config.setTestOnReturn(this.poolTestOnReturn);
        return config;
    }

    private void printRedisConfig() {
        logger.info("plugin-cache-config:redis:host:{}, port:{}, timeout:{}, pwd:{}, database:{}", new Object[]{this.host, this.port, this.timeout, this.pwd, this.database});
        logger.info("plugin-cache-config:reids:poolMaxTotal:{}, poolMaxIdle:{}, poolMaxWaitMillis:{}, poolTestOnBorrow:{}, poolTestOnReturn:{}", new Object[]{this.poolMaxTotal, this.poolMaxIdle, this.poolMaxWaitMillis, this.poolTestOnBorrow, this.poolTestOnReturn});
    }

    @Bean
    @Primary
    @Conditional(value={SignleOrNot.class})
    public JedisPool jedisPool() {
        JedisPool jedisPool = StringUtils.isNotEmpty((CharSequence)this.pwd) ? new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig(), this.host, this.port, this.timeout, this.pwd, this.database) : new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig(), this.host, this.port, this.timeout);
        return jedisPool;
    }

    @Bean
    @Primary
    @Conditional(value={ClusterOrNot.class})
    public JedisCluster jedisCluster() {
        String clusterNodes = this.host;
        String[] cNodes = clusterNodes.split(",");
        HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
        for (String node : cNodes) {
            String[] hp = node.split(":");
            nodes.add(new HostAndPort(hp[0], Integer.parseInt(hp[1])));
        }
        JedisCluster jedisCluster = StringUtils.isNotEmpty((CharSequence)this.pwd) ? new JedisCluster(nodes, this.timeout, this.soTimeOut, this.maxAttemts, this.pwd, (GenericObjectPoolConfig)this.jedisPoolConfig()) : new JedisCluster(nodes, this.timeout, this.soTimeOut, this.maxAttemts, (GenericObjectPoolConfig)this.jedisPoolConfig());
        return jedisCluster;
    }

    @Bean
    @Primary
    @Conditional(value={ClusterOrNot.class})
    public RedisClusterManager redisClusterManager() {
        RedisClusterManager manager = new RedisClusterManager();
        manager.setJedisClusterPool(this.jedisCluster());
        manager.setExpire(0);
        return manager;
    }

    @Bean
    @Primary
    @Conditional(value={SignleOrNot.class})
    public RedisManager redisManager() {
        RedisManager manager = new RedisManager();
        manager.setJedisPool(this.jedisPool());
        return manager;
    }

    @Bean
    @Primary
    public CacheClient cacheClient() {
        CacheClientImpl cacheClient = new CacheClientImpl();
        if (this.host.indexOf(",") > -1) {
            logger.info("redis-cluster \u542f\u52a8");
            cacheClient.setCacheManager(this.redisClusterManager());
        } else {
            logger.info("redis \u5355\u673a\u542f\u52a8");
            cacheClient.setCacheManager(this.redisManager());
        }
        return cacheClient;
    }
}

