package com.ohaotian.plugin.cache;

import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;

import java.util.Map;
import java.util.Set;

/**
 * <p>
 * 标题: 通用缓存底层接口
 * </p>
 * <p>
 * 描述:
 * </p>
 * <p>
 * 公司: www.chinaunicom.com
 * </p>
 *
 * @autho liuce
 * @time 2016-5-15 下午7:18:04
 */
public interface CacheManager {

    /**
     * <p>
     * 方法名称：根据key获取value值
     * </p>
     * <p>
     * 方法说明：
     * </p>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016-5-15 下午7:30:22
     */
    byte[] get(byte[] key);

    /**
     * <p>
     * 方法名称：设置一个不过期的记录
     * </p>
     * <p>
     * 方法说明：
     * </p>
     *
     * @param key
     * @param value
     * @return
     * @autho liuce
     * @time 2016-5-15 下午7:31:08
     */
    byte[] set(byte[] key, byte[] value);

    /**
     * <p>
     * 方法名称：设置一个带失效时间的记录
     * </p>
     * <p>
     * 方法说明：
     * </p>
     *
     * @param key
     * @param value
     * @param expire
     * @return
     * @autho liuce
     * @time 2016-5-15 下午7:32:01
     */
    byte[] set(byte[] key, byte[] value, int expire);

    String set(String key, String value);

    String set(String key, String value, int expire);

    /**
     * <p>
     * 方法名称：根据key删除记录
     * </p>
     * <p>
     * 方法说明：
     * </p>
     *
     * @param key
     * @autho liuce
     * @time 2016-5-15 下午7:32:31
     */
    void del(byte[] key);

    /**
     * <p>
     * 方法名称：删除当前库中的所有元素
     * </p>
     * <p>
     * 方法说明：
     * </p>
     *
     * @autho liuce
     * @time 2016-5-15 下午7:49:10
     */
    void flushDB();

    /**
     * <p>
     * 方法名称：根据前缀查询对应的key
     * </p>
     * <p>
     * 方法说明：
     * </p>
     *
     * @param pattern
     * @return
     * @autho liuce
     * @time 2016-5-15 下午8:00:36
     */
    Set<byte[]> keys(String pattern);

    /**
     * <p>
     * 方法名称：根据前缀查询对应的scan
     * </p>
     * <p>
     * 方法说明：
     * </p>
     *
     * @param pattern
     * @return
     * @autho gujb
     * @time 2022年10月9日16:35:37
     */
    Set<String> scan(String pattern);

    /**
     * 获取tair中key的数量<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho liuce
     * @time 2016-5-26 上午12:55:08
     */
    Long dbSize();

    /**
     * 修改value的超时时间<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @autho liuce
     * @time 2016年11月6日 上午2:23:00
     */
    void setValueExpireTime(byte[] key, int expire);

    /**
     * 获取key的失效时间<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年11月9日 上午12:10:41
     */
    Long getExpireTimeByKey(byte[] key);

    /**
     * redis计数器，没有失效时间的<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:42:39
     */
    Long incr(byte[] key);

    /**
     * redis计数器，有失效时间<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param expire
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:43:16
     */
    Long incrExpireTime(byte[] key, int expire);

    /**
     * redis计数器，没有失效时间的<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:42:39
     */
    Long incrBy(byte[] key, long num);

    /**
     * redis计数器，有失效时间<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @param expire
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午3:43:16
     */
    Long incrExpireTimeBy(byte[] key, long num, int expire);

    /**
     * 获取计数器的值<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param key
     * @return
     * @autho liuce
     * @time 2016年12月30日 下午4:11:41
     */
    Long getIncr(byte[] key);

    //队列操作 begin

    /**
     * <p>通过key向list尾部添加字符串</p>
     *
     * @param key
     * @param value
     * @return 返回list的value个数
     */
    Long rpush(byte[] key, byte[] value);

    /**
     * <p>通过key从list的头部删除一个value,并返回该value</p>
     *
     * @param key
     * @return
     */
    String lpop(String key);

    /**
     * <p>通过key返回list的长度.
     * LLEN命令将返回存储在key列表的长度。如果key不存在，它被解释为一个空列表，则返回0。当存储在关key的值不是一个列表，则会返回错误。</p>
     *
     * @param key
     * @return
     */
    Long llen(String key);
    //队列操作 end

    //分布式锁 begin

    /**
     * 将 key 的值设为 value ，当且仅当 key 不存在。
     * 若给定的 key 已经存在，则 SETNX 不做任何动作。
     * SETNX 是『SET if Not eXists』(如果不存在，则 SET)的简写
     *
     * @param key
     * @return 返回值：设置成功，返回 1 。设置失败，返回 0 。
     */
    Long setnx(byte[] key, byte[] value);

    /**
     * 语法：
     * GETSET key value
     * 功能：
     * 将给定 key 的值设为 value ，并返回 key 的旧值 (old value)，当 key 存在但不是字符串类型时，返回一个错误，当key不存在时，返回nil。
     */
    byte[] getSet(byte[] key, byte[] value);

    //分布式锁 end
    JedisPool getJedisPool();

    JedisCluster getJedisCluster();

    JedisSentinelPool getJedisSentinel();

    <T> T blpop(String key, int waitSeconds, Class<T> clazz);

    Long expire(String key, int secound);

    Map<String, String> hgetAll(String key);

    Long hdel(String key, String... fields);

    Long hset(String key, String field, String value);

    String hget(String key, String field);

}
