package com.ohaotian.plugin.cache.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * @描述：
 * @作者： 李佳琪
 * @时间 2020-04-09
 */
public class SentinelOrNot implements Condition {
    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment environment = conditionContext.getEnvironment();
        String masterName = environment.getProperty("redis.masterName");
        if (masterName != null && StringUtils.isNotBlank(masterName)) {
            return true;
        } else {
            return false;
        }
    }
}
