/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache;

import com.ohaotian.plugin.cache.CacheManager;
import com.ohaotian.plugin.util.ConvertUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public class RedisClusterManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(RedisClusterManager.class);
    private String host = "115.28.105.99";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "BJtGXdevRedis123";
    private JedisCluster jedisCluster;

    @Override
    public byte[] get(byte[] key) {
        byte[] value = null;
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        value = jedisCluster.get(key);
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.set(key, value);
        if (this.expire != 0) {
            jedisCluster.expire(key, (long)this.expire);
        }
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.set(key, value);
        if (expire != 0) {
            jedisCluster.expire(key, (long)expire);
        }
        return value;
    }

    @Override
    public String set(String key, String value) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.set(key, value);
        if (this.expire != 0) {
            jedisCluster.expire(key, (long)this.expire);
        }
        return value;
    }

    @Override
    public String set(String key, String value, int expire) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.set(key, value);
        if (expire != 0) {
            jedisCluster.expire(key, (long)expire);
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.del(key);
    }

    @Override
    public void flushDB() {
        throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
    }

    @Override
    public Long dbSize() {
        throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
    }

    @Override
    public Set<byte[]> keys(String pattern) {
        ScanResult scanResult;
        JedisCluster jedisCluster = this.getJedisCluster();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        byte[] cursor = "0".getBytes(StandardCharsets.UTF_8);
        ScanParams scanParams = new ScanParams().count(Integer.valueOf(100)).match(pattern.getBytes(StandardCharsets.UTF_8));
        do {
            scanResult = jedisCluster.scan(cursor, scanParams);
            keys.addAll(scanResult.getResult());
        } while (!new String(cursor = scanResult.getCursorAsBytes(), StandardCharsets.UTF_8).equals("0"));
        return keys;
    }

    @Override
    public Set<String> scan(String pattern) {
        List resultList;
        ScanResult scan;
        HashSet<String> scans = new HashSet<String>();
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        log.debug("Start getting scan... ");
        ScanParams scanParams = new ScanParams();
        scanParams.match(pattern);
        scanParams.count(Integer.valueOf(1000));
        String scanStart = ScanParams.SCAN_POINTER_START;
        while (!ScanParams.SCAN_POINTER_START.equals(scanStart = (scan = jedisCluster.scan(scanStart, scanParams)).getCursor()) && (resultList = scan.getResult()) != null && resultList.size() != 0) {
            scans.addAll(resultList);
        }
        return scans;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    @Override
    public JedisSentinelPool getJedisSentinel() {
        return null;
    }

    @Override
    public JedisPool getJedisPool() {
        return null;
    }

    public void setJedisClusterPool(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    @Override
    public void setValueExpireTime(byte[] key, int expire) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        if (expire != 0) {
            jedisCluster.expire(key, (long)expire);
        }
    }

    @Override
    public Long getExpireTimeByKey(byte[] key) {
        Long expireTime = -1L;
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        expireTime = jedisCluster.ttl(key);
        return expireTime;
    }

    @Override
    public Long incr(byte[] key) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incr(key);
        return num;
    }

    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incr(key);
        jedisCluster.expire(key, (long)expire);
        return num;
    }

    @Override
    public Long incrBy(byte[] key, long conut) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incrBy(key, conut);
        return num;
    }

    @Override
    public Long incrExpireTimeBy(byte[] key, long conut, int expire) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incrBy(key, conut);
        jedisCluster.expire(key, (long)expire);
        return num;
    }

    @Override
    public Long getIncr(byte[] key) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        byte[] bnum = jedisCluster.get(key);
        String numStr = bnum == null ? null : new String(bnum);
        num = numStr == null ? null : Long.valueOf(Long.parseLong(numStr));
        return num;
    }

    @Override
    public Long rpush(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        Long res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.rpush(key, (byte[][])new byte[][]{value});
        return res;
    }

    @Override
    public String lpop(String key) {
        JedisCluster jedisCluster = null;
        String res = null;
        jedisCluster = this.getJedisCluster();
        byte[] bytes = jedisCluster.lpop(key.getBytes());
        res = new String(bytes);
        return res;
    }

    @Override
    public Long llen(String key) {
        JedisCluster jedisCluster = null;
        Long res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.llen(key.getBytes());
        return res;
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        Long res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.setnx(key, value);
        return res;
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        byte[] res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.getSet(key, value);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        T t;
        block5: {
            JedisCluster jedisCluster = null;
            jedisCluster = this.getJedisCluster();
            List values = jedisCluster.brpop(waitSeconds, (byte[][])new byte[][]{key.getBytes()});
            if (values == null || values.size() <= 0) break block5;
            byte[] value = (byte[])values.get(1);
            T t2 = ConvertUtil.unserialize(value, clazz);
            return t2;
        }
        try {
            t = null;
        }
        catch (Exception e) {
            T t3 = null;
            return t3;
        }
        return t;
    }

    @Override
    public Long expire(String key, int secound) {
        JedisCluster jedisCluster = null;
        Long expire = null;
        jedisCluster = this.getJedisCluster();
        expire = jedisCluster.expire(key, (long)secound);
        return expire;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.jedisCluster.hgetAll(key);
    }

    @Override
    public Long hdel(String key, String ... fields) {
        return this.jedisCluster.hdel(key, fields);
    }

    @Override
    public Long hset(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value);
    }

    @Override
    public String hget(String key, String field) {
        return this.jedisCluster.hget(key, field);
    }
}

