/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache;

import com.ohaotian.plugin.cache.CacheManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(RedisManager.class);
    private String host = "115.28.105.99";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "BJtGXdevRedis123";
    private RedissonClient jedisPool = null;
    private RedissonClient redissonClient = null;

    public RedisManager() {
    }

    public RedisManager(String host, int port, String password) {
        this.host = host;
        this.port = port;
        this.password = password;
    }

    public RedisManager(String host, int port, String password, int expire, int timeout) {
        this.host = host;
        this.port = port;
        this.password = password;
        this.expire = expire;
        this.timeout = timeout;
    }

    @Override
    public byte[] get(byte[] key) {
        String keyStr = new String(key);
        RBucket bucket = this.getJedisPool().getBucket(keyStr);
        byte[] valueStr = (byte[])bucket.get();
        return valueStr;
    }

    @Override
    public byte[] set(byte[] key, byte[] value) {
        String keyStr = new String(key);
        RBucket bucket = this.getJedisPool().getBucket(keyStr);
        bucket.set((Object)value);
        if (this.expire != 0) {
            bucket.expire((long)this.expire, TimeUnit.SECONDS);
        }
        return value;
    }

    @Override
    public String set(String key, String value) {
        RBucket bucket = this.getJedisPool().getBucket(key);
        bucket.set((Object)value);
        if (this.expire != 0) {
            bucket.expire((long)this.expire, TimeUnit.SECONDS);
        }
        return value;
    }

    @Override
    public String set(String key, String value, int expire) {
        RBucket bucket = this.getJedisPool().getBucket(key);
        bucket.set((Object)value);
        bucket.expire((long)expire, TimeUnit.SECONDS);
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        String keyStr = new String(key);
        RBucket bucket = this.getJedisPool().getBucket(keyStr);
        bucket.set((Object)value);
        bucket.expire((long)expire, TimeUnit.SECONDS);
        return value;
    }

    @Override
    public void del(byte[] key) {
        String keyStr = new String(key);
        RKeys keys = this.getJedisPool().getKeys();
        keys.delete(new String[]{keyStr});
    }

    @Override
    public void flushDB() {
    }

    @Override
    public Long dbSize() {
        RKeys keys = this.getJedisPool().getKeys();
        return keys.count();
    }

    @Override
    public Set<byte[]> keys(String pattern) {
        RKeys keys = this.getJedisPool().getKeys();
        Iterable iterable = keys.getKeysByPattern(pattern);
        Iterator iterator = iterable.iterator();
        HashSet<byte[]> byteKeys = new HashSet<byte[]>();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            byteKeys.add(key.getBytes());
        }
        return byteKeys;
    }

    @Override
    public Set<String> scan(String pattern) {
        RKeys keys = this.getJedisPool().getKeys();
        Iterable iterable = keys.getKeysByPattern(pattern);
        Iterator iterator = iterable.iterator();
        HashSet<String> byteKeys = new HashSet<String>();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            byteKeys.add(key);
        }
        return byteKeys;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public RedissonClient getJedisPool() {
        return this.redissonClient;
    }

    public void setJedisPool(RedissonClient jedisPool) {
        this.redissonClient = jedisPool;
    }

    @Override
    public RedissonClient getJedisCluster() {
        return null;
    }

    @Override
    public void setValueExpireTime(byte[] key, int expire) {
        String keyStr = new String(key);
        RBucket bucket = this.getJedisPool().getBucket(keyStr);
        if (expire > 0) {
            bucket.expire((long)expire, TimeUnit.SECONDS);
        }
    }

    @Override
    public Long getExpireTimeByKey(byte[] key) {
        String keyStr = new String(key);
        RBucket bucket = this.getJedisPool().getBucket(keyStr);
        return bucket.getExpireTime();
    }

    @Override
    public Long incr(byte[] key) {
        String keyStr = new String(key);
        RAtomicLong atomicLong = this.getJedisPool().getAtomicLong(keyStr);
        return atomicLong.incrementAndGet();
    }

    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        String keyStr = new String(key);
        RAtomicLong atomicLong = this.getJedisPool().getAtomicLong(keyStr);
        atomicLong.incrementAndGet();
        return atomicLong.get();
    }

    @Override
    public Long incrBy(byte[] key, long count) {
        String keyStr = new String(key);
        RAtomicLong atomicLong = this.getJedisPool().getAtomicLong(keyStr);
        return atomicLong.addAndGet(count);
    }

    @Override
    public Double incrByFloat(byte[] key, double increment) {
        String keyStr = new String(key);
        RBucket bucket = this.getJedisPool().getBucket(keyStr);
        Double num = null;
        Double currentValue = (Double)bucket.get();
        if (currentValue == null) {
            currentValue = 0.0;
        }
        num = currentValue + increment;
        bucket.set((Object)num);
        return num;
    }

    @Override
    public Long incrExpireTimeBy(byte[] key, long count, int expire) {
        String keyStr = new String(key);
        RAtomicLong atomicLong = this.getJedisPool().getAtomicLong(keyStr);
        Long num = null;
        num = atomicLong.addAndGet(count);
        return num;
    }

    @Override
    public Long getIncr(byte[] key) {
        RBucket bucket = this.getJedisPool().getBucket(new String(key));
        String value = (String)bucket.get();
        Long num = null;
        if (value != null) {
            num = Long.parseLong(value);
        }
        return num;
    }

    @Override
    public Long rpush(byte[] key, byte[] value) {
        String keyStr = new String(key);
        RList list = this.getJedisPool().getList(keyStr);
        list.add((Object)value);
        return list.size();
    }

    @Override
    public String lpop(String key) {
        RQueue queue = this.getJedisPool().getQueue(key);
        String value = (String)queue.poll();
        return value;
    }

    @Override
    public Long llen(String key) {
        RList list = this.getJedisPool().getList(key);
        return list.size();
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        String keyStr = new String(key);
        RBucket bucket = this.redissonClient.getBucket(keyStr);
        boolean exists = bucket.isExists();
        if (!exists) {
            bucket.set((Object)value);
            return 1L;
        }
        return 0L;
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        String keyStr = new String(key);
        RBucket bucket = this.getJedisPool().getBucket(keyStr);
        byte[] oldValue = (byte[])bucket.get();
        bucket.set((Object)value);
        return oldValue;
    }

    @Override
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        RBlockingQueue queue = this.getJedisPool().getBlockingQueue(key);
        try {
            String value = (String)queue.poll((long)waitSeconds, TimeUnit.SECONDS);
            if (value != null) {
                return clazz.cast(value);
            }
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public Long expire(String key, int secound) {
        RBucket bucket = this.getJedisPool().getBucket(key);
        bucket.expire((long)secound, TimeUnit.SECONDS);
        return secound;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        RMap map = this.getJedisPool().getMap(key);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : map.readAllEntrySet()) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    @Override
    public Long hdel(String key, String ... fields) {
        RMap map = this.getJedisPool().getMap(key);
        return (Long)map.remove((Object)fields);
    }

    @Override
    public Long hset(String key, String field, String value) {
        RMap map = this.getJedisPool().getMap(key);
        map.put((Object)field, (Object)value);
        return 1L;
    }

    @Override
    public String hget(String key, String field) {
        RMap map = this.getJedisPool().getMap(key);
        return (String)map.get((Object)field);
    }
}

