/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache.config;

import com.ohaotian.license.verify.service.LicenseVerifyService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.cache.RedisClusterManager;
import com.ohaotian.plugin.cache.RedisManager;
import com.ohaotian.plugin.cache.config.ClusterOrNot;
import com.ohaotian.plugin.cache.config.SignleOrNot;
import com.ohaotian.plugin.cache.impl.CacheClientImpl;
import com.ohaotian.plugin.common.util.RSAUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class PluginCacheConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginCacheConfig.class);
    @Value(value="${redis.host}")
    private String host;
    @Value(value="${redis.port}")
    private int port;
    @Value(value="${redis.timeout}")
    private int timeout;
    @Value(value="${spring.application.name:unknown}")
    private String clientName;
    @Value(value="${redis.user:}")
    private String user;
    @Value(value="${redis.pwd:}")
    private String pwd;
    @Value(value="${redis.pwd.publicKey:}")
    private String publicKey;
    @Value(value="${redis.database:0}")
    private int database;
    @Value(value="${redis.soTimeOut:2000}")
    private int soTimeOut;
    @Value(value="${redis.maxAttemts:5}")
    private int maxAttemts;
    @Value(value="${redis.pool.maxTotal}")
    private int poolMaxTotal;
    @Value(value="${redis.pool.maxIdle}")
    private int poolMaxIdle;
    @Value(value="${redis.pool.maxWaitMillis}")
    private int poolMaxWaitMillis;
    @Value(value="${redis.pool.testOnBorrow:false}")
    private boolean poolTestOnBorrow;
    @Value(value="${redis.pool.testOnReturn:false}")
    private boolean poolTestOnReturn;
    @Autowired
    private LicenseVerifyService licenseVerifyService;

    public void encrypt() {
        if (StringUtils.isNotEmpty((CharSequence)this.publicKey)) {
            try {
                logger.info("redis\u5bc6\u7801\u542f\u7528\u52a0\u5bc6\uff01");
                this.pwd = RSAUtil.decrypt((String)this.publicKey, (String)this.pwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            RSAUtil.genKeyPair((String)"123abcd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printRedisConfig() {
        logger.info("plugin-cache-config:redis:host:{}, port:{}, timeout:{}, pwd:{}, database:{}, user:{}", new Object[]{this.host, this.port, this.timeout, this.pwd, this.database, this.user});
        logger.info("plugin-cache-config:reids:poolMaxTotal:{}, poolMaxIdle:{}, poolMaxWaitMillis:{}, poolTestOnBorrow:{}, poolTestOnReturn:{}", new Object[]{this.poolMaxTotal, this.poolMaxIdle, this.poolMaxWaitMillis, this.poolTestOnBorrow, this.poolTestOnReturn});
    }

    @Bean
    @Primary
    @Conditional(value={SignleOrNot.class})
    public RedissonClient redissonClient() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        ((SingleServerConfig)singleServerConfig.setAddress("redis://" + this.host + ":" + this.port).setPassword(this.pwd)).setConnectionPoolSize(this.poolMaxTotal).setConnectionMinimumIdleSize(this.poolMaxIdle).setDatabase(this.database);
        if (StringUtils.isNotBlank((CharSequence)this.user)) {
            singleServerConfig.setUsername(this.user);
        }
        return Redisson.create((Config)config);
    }

    @Bean
    @Primary
    @Conditional(value={ClusterOrNot.class})
    public RedissonClient jedisCluster() {
        String clusterNodes = this.host;
        ArrayList<String> nodeAddresses = new ArrayList<String>();
        for (String node : clusterNodes.split(",")) {
            if (!node.startsWith("redis://") && !node.startsWith("rediss://")) {
                node = "redis://" + node;
            }
            nodeAddresses.add(node);
        }
        Config config = new Config();
        ClusterServersConfig clusterConfig = config.useClusterServers();
        clusterConfig.setNodeAddresses(nodeAddresses);
        if (StringUtils.isNotBlank((CharSequence)this.pwd)) {
            clusterConfig.setPassword(this.pwd);
        }
        if (StringUtils.isNotBlank((CharSequence)this.user)) {
            clusterConfig.setUsername(this.user);
        }
        clusterConfig.setConnectTimeout(this.timeout);
        clusterConfig.setTimeout(this.soTimeOut);
        clusterConfig.setRetryAttempts(this.maxAttemts);
        clusterConfig.setRetryInterval(1000);
        clusterConfig.setMasterConnectionPoolSize(this.poolMaxTotal);
        clusterConfig.setMasterConnectionMinimumIdleSize(this.poolMaxIdle);
        clusterConfig.setSlaveConnectionPoolSize(this.poolMaxTotal);
        clusterConfig.setSlaveConnectionMinimumIdleSize(this.poolMaxIdle);
        clusterConfig.setScanInterval(2000);
        return Redisson.create((Config)config);
    }

    @Bean
    @Primary
    @Conditional(value={ClusterOrNot.class})
    public RedisClusterManager redisClusterManager() {
        RedisClusterManager manager = new RedisClusterManager();
        manager.setJedisClusterPool(this.jedisCluster());
        manager.setExpire(0);
        return manager;
    }

    @Bean
    @Primary
    @Conditional(value={SignleOrNot.class})
    public RedisManager redisManager() {
        RedisManager manager = new RedisManager();
        manager.setJedisPool(this.redissonClient());
        return manager;
    }

    @Bean
    @Primary
    public CacheClient cacheClient() {
        CacheClientImpl cacheClient = new CacheClientImpl();
        if (this.host.indexOf(",") > -1) {
            logger.info("redis-cluster \u542f\u52a8");
            cacheClient.setCacheManager(this.redisClusterManager());
        } else {
            logger.info("redis \u5355\u673a\u542f\u52a8");
            cacheClient.setCacheManager(this.redisManager());
        }
        return cacheClient;
    }
}

