package com.ohaotian.plugin.common.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

import javax.servlet.http.HttpServletResponse;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 统一格式返回
 *
 * @author liubq
 */
public class ReturnValueHandler implements HandlerMethodReturnValueHandler {


    private Logger logger = LoggerFactory.getLogger(ReturnValueHandler.class);


    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        boolean hasJSONAnno = returnType.getMethodAnnotation(BusiResponseBody.class) != null || returnType.getMethodAnnotation(BusiResponseBody.class) != null;
        return hasJSONAnno;
    }

    @Override
    public void handleReturnValue(Object obj, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer,
                                  NativeWebRequest nativeWebRequest) throws Exception {
        modelAndViewContainer.setRequestHandled(true);
        HttpServletResponse response = nativeWebRequest.getNativeResponse(HttpServletResponse.class);
        response.setContentType(MediaType.APPLICATION_JSON_UTF8_VALUE);
        logger.info("请求成功，返回消息转换");
        Map<String, Object> rsp = new HashMap<>();
        //返回封装数据
        if (obj instanceof RspPageBO) {
            rsp.put("data", obj);
            rsp.put("code", BaseRspConstants.RSP_DESC_SUCCESS);
            rsp.put("message", BaseRspConstants.RSP_CODE_SUCCESS);
            returnMsg(rsp, response);
        } else if (obj instanceof RspBusiBaseBO) {
            Map<String, Object> transBean2Map = transBean2Map(obj);
            rsp.put("code", BaseRspConstants.RSP_CODE_SUCCESS);
            rsp.put("message", BaseRspConstants.RSP_DESC_SUCCESS);
            transBean2Map.remove("code");
            transBean2Map.remove("message");
            if (transBean2Map.size() == 1) {
                Set<String> keySet = transBean2Map.keySet();
                for (String str : keySet) {
                    Object o = transBean2Map.get(str);
                    rsp.put("data", o);
                }
            } else {
                rsp.put("data", transBean2Map);
            }
            returnMsg(rsp, response);
        } else {
            Map<String, Object> transBean2Map = transBean2Map(obj);
            rsp.put("code", BaseRspConstants.RSP_DESC_SUCCESS);
            rsp.put("message", BaseRspConstants.RSP_CODE_SUCCESS);
            if (transBean2Map != null && !transBean2Map.isEmpty()) {
                rsp.put("data", obj);
            }
            returnMsg(rsp, response);

        }


    }

    /**
     * 返回给前端信息
     *
     * @param msg
     * @param response
     */
    private void returnMsg(Object msg, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            response.setContentType("text/plain;charset=UTF-8");
            writer = response.getWriter();
            writer.write(JSON.toJSONString(msg, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse));
            writer.flush();
        } catch (IOException ex) {
            logger.error("统一格式返回", ex);
        } finally {
            if (writer != null)
                writer.close();
        }
    }


    /**
     * 方法描述： javaBean转map
     *
     * @param obj
     * @return
     */
    private Map<String, Object> transBean2Map(Object obj) {

        if (obj == null) {
            return null;
        }
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (PropertyDescriptor property : propertyDescriptors) {
                String key = property.getName();

                // 过滤class属性
                if (!key.equals("class")) {
                    // 得到property对应的getter方法
                    Method getter = property.getReadMethod();
                    Object value = getter.invoke(obj);

                    map.put(key, value);
                }

            }
        } catch (Exception e) {
            logger.error("transBean2Map Error ", e);
        }

        return map;

    }


}
