package com.ohaotian.plugin.common.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

import com.ohaotian.plugin.base.bo.RspInfoBO;

public class ExcelExport<T> {
    // 表格标题
    private String sheetTitle = "Sheet1";
    // 列标题及列宽
    private String[] headers = {};
    // 数据集
    private List<T> datasets = new ArrayList<T>();
    // 日期输出格式
    private String dateFormat = "yyyy-MM-dd";
    // 输出流
    private FileOutputStream fileout = null;

    public ExcelExport() {
        super();
    }
    public ExcelExport(List<T> datasets, FileOutputStream fileout) {
        super();
        this.datasets = datasets;
        this.fileout = fileout;
    }
    public ExcelExport(String sheetTitle, List<T> datasets, FileOutputStream fileout) {
        this(datasets, fileout);
        this.sheetTitle = sheetTitle;
    }
    public ExcelExport(String[] headers, List<T> datasets, FileOutputStream fileout) {
        this(datasets, fileout);
        this.headers = headers;
    }
    public ExcelExport(String sheetTitle, String[] headers, List<T> datasets, FileOutputStream fileout) {
        this(sheetTitle, datasets, fileout);
        this.headers = headers;
    }
    public ExcelExport(String sheetTitle, String[] headers, List<T> datasets, String dateFormat, FileOutputStream fileout) {
        this(sheetTitle, headers, datasets, fileout);
        this.dateFormat = dateFormat;
    }

    public ExcelExport(List<T> datasets) {
        this.datasets = datasets;
    }
    public ExcelExport(String[] headers, List<T> datasets) {
        this.headers = headers;
        this.datasets = datasets;
    }

    /**
     * 利用JAVA的反射机制，将集合中的数据输出到指定IO流中
     *
     *
     * @throws Exception
     *             异常
     */
    public RspInfoBO ExportExcel() throws Exception {
        RspInfoBO RspInfo = new RspInfoBO();
        // 声明一个工作薄
        HSSFWorkbook workbook = new HSSFWorkbook();
        // 生成一个表格
        HSSFSheet sheet = workbook.createSheet(sheetTitle);
        // 标题样式
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        // 设置水平居中
        titleStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        // 设置垂直居中
        titleStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        // 标题字体
        HSSFFont titleFont = workbook.createFont();
        titleFont.setFontName("微软雅黑");
        titleFont.setFontHeightInPoints((short) 12);
        // 把字体应用到当前的样式
        titleStyle.setFont(titleFont);
        // 正文样式
        HSSFCellStyle bodyStyle = workbook.createCellStyle();
        bodyStyle.cloneStyleFrom(titleStyle);
        // 正文字体
        HSSFFont bodyFont = workbook.createFont();
        bodyFont.setFontName("宋体");
        bodyFont.setColor(HSSFColor.BLACK.index);
        bodyFont.setFontHeightInPoints((short) 12);
        bodyStyle.setFont(bodyFont);
        int index = 0;
        HSSFRow row = null;
        if (headers.length > 0) {
            // 产生表格标题行
            row = sheet.createRow(index++);
            // 设置行高
            row.setHeightInPoints(15f);
            for (int i = 0; i < headers.length; i++) {
                HSSFCell cell = row.createCell(i);
                HSSFRichTextString text = new HSSFRichTextString(headers[i]);
                cell.setCellValue(text);
                cell.setCellStyle(titleStyle);
            }
        }
        // 遍历集合数据，产生数据行
        Iterator<T> it = datasets.iterator();
        while (it.hasNext()) {
            row = sheet.createRow(index);
            // 设置行高
            row.setHeightInPoints(15f);
            Object t = it.next();
            // 利用反射，得到属性值
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; i++) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(bodyStyle);
                Field field = fields[i];
                field.setAccessible(true);
                Object value = field.get(t);
                // 判断值的类型后进行强制类型转换
                String textValue = null;
                if (value instanceof Date) {
                    Date date = (Date) value;
                    SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                    textValue = sdf.format(date);
                } else {
                    // 其它数据类型都当作字符串简单处理
                    textValue = value.toString();
                }
                // 如果不是图片数据，就利用正则表达式判断textValue是否全部由数字组成
                if (textValue != null) {
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        // 是数字当作double处理
                        cell.setCellValue(Double.parseDouble(textValue));
                    } else {
                        cell.setCellValue(textValue);
                    }
                }
            }
            index++;
        }
        workbook.write(fileout);

        fileout.flush();
        fileout.close();

        return RspInfo;
    }



    /**
     * 利用JAVA的反射机制，将集合中的数据输出到指定IO流中
     *
     *
     * @throws Exception
     *             异常
     */
    public RspInfoBO ExportExcelTOStream(OutputStream outputStream) throws Exception {
        // 声明一个工作薄
        HSSFWorkbook workbook = new HSSFWorkbook();
        // 生成一个表格
        HSSFSheet sheet = workbook.createSheet(sheetTitle);
        // 标题样式
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        // 设置水平居中
        titleStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        // 设置垂直居中
        titleStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        // 标题字体
        HSSFFont titleFont = workbook.createFont();
        titleFont.setFontName("微软雅黑");
        titleFont.setFontHeightInPoints((short) 12);
        // 把字体应用到当前的样式
        titleStyle.setFont(titleFont);
        // 正文样式
        HSSFCellStyle bodyStyle = workbook.createCellStyle();
        bodyStyle.cloneStyleFrom(titleStyle);
        // 正文字体
        HSSFFont bodyFont = workbook.createFont();
        bodyFont.setFontName("宋体");
        bodyFont.setColor(HSSFColor.BLACK.index);
        bodyFont.setFontHeightInPoints((short) 12);
        bodyStyle.setFont(bodyFont);
        int index = 0;
        HSSFRow row = null;
        if (headers.length > 0) {
            // 产生表格标题行
            row = sheet.createRow(index++);
            // 设置行高
            row.setHeightInPoints(15f);
            for (int i = 0; i < headers.length; i++) {
                HSSFCell cell = row.createCell(i);
                HSSFRichTextString text = new HSSFRichTextString(headers[i]);
                cell.setCellValue(text);
                cell.setCellStyle(titleStyle);
            }
        }
        // 遍历集合数据，产生数据行
        Iterator<T> it = datasets.iterator();
        while (it.hasNext()) {
            row = sheet.createRow(index);
            // 设置行高
            row.setHeightInPoints(15f);
            Object t = it.next();
            // 利用反射，得到属性值
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; i++) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(bodyStyle);
                Field field = fields[i];
                field.setAccessible(true);
                Object value = field.get(t);
                // 判断值的类型后进行强制类型转换
                String textValue = null;
                if (value instanceof Date) {
                    Date date = (Date) value;
                    SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                    textValue = sdf.format(date);
                } else {
                    // 其它数据类型都当作字符串简单处理
                    textValue = value == null ? "" : value.toString();
                }
                // 如果不是图片数据，就利用正则表达式判断textValue是否全部由数字组成
                if (textValue != null) {
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        // 是数字当作double处理
                        cell.setCellValue(Double.parseDouble(textValue));
                    } else {
                        cell.setCellValue(textValue);
                    }
                }
            }
            index++;
        }
        workbook.write(outputStream);

        return new RspInfoBO();
    }
}
