package com.ohaotian.plugin.common.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.base.bo.ReqInfoBO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;

/** <br>
 * 标题: json工具类<br>
 * 描述: 将javaBean转json字符串，将json字符串转java对象<br>
 * 公司: www.tydic.com<br>
 *
 * @autho liuce
 * @time 2016年9月18日 下午7:15:25 */
public class JsonUtils {

    public static ObjectMapper  objectMapper = new ObjectMapper();

    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    /** 使用泛型方法，把json字符串转换为相应的JavaBean对象。 (1)转换为普通JavaBean：readValue(json,Student.class) (2)转换为List,如List<Student>,将第二个参数传递为Student
     * [].class.然后使用Arrays.asList();方法把得到的数组转换为特定类型的List
     *
     * @param content
     * @param valueType
     * @return */
    public static <T> T jsonStringToJavaBean(String content, Class<T> valueType) {

        if (valueType == null) {
            return null;
        }

        if (content == null) {
            return null;
        }

        try {
            return objectMapper.readValue(content, valueType);
        }
        catch (Exception e) {
            log.error("将字符串转Java对象错误，请检查转换类型！", e);
            throw new ResourceException("C994", "将字符串转Java对象错误，请检查转换类型", e);
        }

    }

    /** json数组转List
     *
     * @param jsonStr
     * @param valueTypeRef
     * @return */
    public static <T> T jsonStringToJavaBean(String jsonStr, TypeReference<T> valueTypeRef) {

        try {
            return objectMapper.readValue(jsonStr, valueTypeRef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }


    /** json数组转List
     *
     * @param jsonStr
     * @param javatype
     * @return */
    public static <T> T jsonStringToJavaBean(String jsonStr, JavaType javatype) {

        try {
            return objectMapper.readValue(jsonStr, javatype);
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    /** 把JavaBean转换为json字符串
     *
     * @param object
     * @return */
    public static String objectBeanToJsonString(Object object) {

        String taskContent = null;
        try {
            if (object == null) {
                taskContent = "";
            }
            else {
                taskContent = objectMapper.writeValueAsString(object);
            }
        }
        catch (JsonProcessingException e) {
            log.error("将对象生成json异常，请检查该对象！", e);
            throw new ResourceException("C991", "对象生成json异常，请检查该对象！", e);
        }

        return taskContent;
    }

    /** 获取泛型的Collection Type
     *
     * @param collectionClass
     *        泛型的Collection
     * @param elementClasses
     *        元素类
     * @return JavaType Java类型
     * @since 1.0 */
    public static JavaType getCollectionType(Class<?> collectionClass, Class<?>... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }

    public static void main(String[] args) {
        List<ReqInfoBO> list = new ArrayList<ReqInfoBO>();
        ReqInfoBO r = new ReqInfoBO();
//        r.setChannelId("125");
        list.add(r);
        B b = new B();
        String str = JsonUtils.objectBeanToJsonString(list);
        b.test(str);
    }

}

class A<T>{
    public void test(String str){
        T t = JsonUtils.jsonStringToJavaBean(str, new TypeReference<T>() {});
        System.out.println(t.getClass());

        Type type = ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Class<?> eclass = getClass(type ,0);
        JavaType javatype = getCollectionType(List.class, eclass);
        T t1 = JsonUtils.jsonStringToJavaBean(str,javatype);
        System.out.println(t1);
    }

    /** 获取泛型的Collection Type
     *
     * @param collectionClass
     *        泛型的Collection
     * @param elementClasses
     *        元素类
     * @return JavaType Java类型
     * @since 1.0 */
    public static JavaType getCollectionType(Class<?> collectionClass, Class<?>... elementClasses) {
        return new ObjectMapper().getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }

    private static Class<?> getClass(Type type, int i) {
        if (type instanceof ParameterizedType) { // 处理泛型类型
            return getGenericClass((ParameterizedType) type, i);
        }
        else if (type instanceof TypeVariable) {
            return getClass(((TypeVariable<?>) type).getBounds()[0], 0); // 处理泛型擦拭对象
        }
        else {// class本身也是type，强制转型
            return (Class<?>) type;
        }
    }

    private static Class<?> getGenericClass(ParameterizedType parameterizedType, int i) {
        Object genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) { // 处理多级泛型
            return (Class<?>) ((ParameterizedType) genericClass).getRawType();
        }
        else if (genericClass instanceof GenericArrayType) { // 处理数组泛型
            return (Class<?>) ((GenericArrayType) genericClass).getGenericComponentType();
        }
        else if (genericClass instanceof TypeVariable) { // 处理泛型擦拭对象
            return getClass(((TypeVariable<?>) genericClass).getBounds()[0], 0);
        }
        else {
            return (Class<?>) genericClass;
        }
    }

}

class B extends A<List<ReqInfoBO>>{
}
