package com.ohaotian.plugin.common.util;

import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ResourceException;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>标题: 集合工具</p>
 * <p>描述: </p>
 * <p>公司: www.chinaunicom.com</p>
 *
 * @autho zy
 * @time 2016年5月22日 下午3:15:36
 */
public class ListUtils {

    /**
     * <p>方法名称：列表间复制</p>
     * <p>方法说明：List—>List</p>
     *
     * @param source 源列表
     * @param clazz  目标列表中的泛型
     * @return 目标列表
     * @throws ResourceException
     * @autho zy
     * @time 2016年5月23日 上午11:11:24
     */
    public static <S, T> List<T> copyListProperties(List<S> source, Class<T> clazz) throws ResourceException {
        return copyListProperties(source, clazz, null);
    }

    /**
     * <p>方法名称：列表间复制</p>
     * <p>方法说明：List—>List</p>
     *
     * @param source  源列表
     * @param clazz   目标列表中的泛型
     * @param command 列表中对象复制的特殊化操作
     * @return 目标列表
     * @throws ResourceException
     * @autho zy
     * @time 2016年5月23日 上午11:11:24
     */
    public static <S, T> List<T> copyListProperties(List<S> source, Class<T> clazz, Command<S, T> command) throws ResourceException {
        List<T> targets = new ArrayList<T>();
        try {
            for (S s : source) {
                T target = clazz.newInstance();
                BeanUtils.copyProperties(s, target);
                if (null != command) {
                    command.operate(s, target);
                }
                targets.add(target);
            }
        } catch (Exception e) {
            throw new ResourceException(BaseRspConstants.RSP_CODE_PARAMETERS_ERROR, "列表操作拷贝错误");
        }
        return targets;
    }

    /**
     * <p>方法名称：对列表进行排除操作</p>
     * <p>方法说明：</p>
     *
     * @param source  排除对象参考
     * @param target  被排除对象集合
     * @param command 排除策略。返回0，则删除。
     * @throws ResourceException
     * @autho zy
     * @time 2016年5月25日 上午10:22:46
     */
    public static <S, T> void exclude(List<S> source, List<T> target, Command<S, T> command) throws ResourceException {
        try {
            for (int i = 0; i < source.size(); i++) {
                for (int j = 0; j < target.size(); j++) {
                    if (Command.SUCCESS == command.operate(source.get(i), target.get(j))) {
                        target.remove(j);
                        break;
                    }
                }
            }
        } catch (Exception e) {
            throw new ResourceException(BaseRspConstants.RSP_CODE_PARAMETERS_ERROR, "列数据排除错误");
        }
    }

    /**
     * <p>方法名称：对列表进行保留操作</p>
     * <p>方法说明：</p>
     *
     * @param source  保留对象参考
     * @param target  被保留对象集合
     * @param command 保留测率。返回0，则保留。
     * @throws ResourceException
     * @autho zy
     * @time 2016年5月25日 上午11:15:44
     */
    public static <S, T> void reserve(List<S> source, List<T> target, Command<S, T> command) throws ResourceException {
        try {
            List<T> tmp = new ArrayList<T>();
            for (int i = 0; i < target.size(); i++) {
                for (int j = 0; j < source.size(); j++) {
                    if (Command.SUCCESS == command.operate(source.get(j), target.get(i))) {
                        tmp.add(target.get(i));
                        break;
                    }
                }
            }
            target.clear();
            target.addAll(tmp);
        } catch (Exception e) {
            throw new ResourceException(BaseRspConstants.RSP_CODE_PARAMETERS_ERROR, "列数据保留错误");
        }
    }

}
