package com.ohaotian.plugin.common.banner;

import com.ohaotian.plugin.common.context.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import java.text.MessageFormat;

/**
 * Liu Zhenhua
 */
@Slf4j
@Component
public class BannerKit implements CommandLineRunner {
    /**
     * 输出昊天平台应用启动信息
     */
    @Override
    public void run(String... args) throws Exception {
        Environment env = SpringContextHolder.getBean(Environment.class);

        System.out.println(
                "***************************[昊天研发平台应用启动成功]**************************\n" +
                        "*                                                                          *\n"+
                        MessageFormat.format("*          ================[{0}]================         *\n",env.getProperty("app.server.host.url"))+
                        "*                                                                          *\n"+
                        "****************************************************************************");
    }
}