/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.util;

import com.ohaotian.plugin.common.util.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTSerializer
implements Serializer {
    @Override
    public String name() {
        return "fst";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FSTObjectOutput fOut = new FSTObjectOutput((OutputStream)out);){
            fOut.writeObject(obj);
            fOut.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        Object object;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        FSTObjectInput in = new FSTObjectInput((InputStream)new ByteArrayInputStream(bytes));
        try {
            object = in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException();
            }
        }
        in.close();
        return object;
    }
}

