/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.uuid.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySql5PageHepler {
    public static String getCountString(String querySelect) {
        querySelect = MySql5PageHepler.getLineSql(querySelect);
        int orderIndex = MySql5PageHepler.getLastOrderInsertPoint(querySelect);
        int formIndex = MySql5PageHepler.getAfterFormInsertPoint(querySelect);
        String select = querySelect.substring(0, formIndex);
        if (select.toLowerCase().indexOf("select distinct") != -1 || querySelect.toLowerCase().indexOf("group by") != -1) {
            return new StringBuffer(querySelect.length()).append("select count(1) count from (").append(querySelect.substring(0, orderIndex)).append(" ) t").toString();
        }
        return new StringBuffer(querySelect.length()).append("select count(1) count ").append(querySelect.substring(formIndex, orderIndex)).toString();
    }

    private static int getLastOrderInsertPoint(String querySelect) {
        int orderIndex = querySelect.toLowerCase().lastIndexOf("order by");
        if (orderIndex == -1) {
            orderIndex = querySelect.length();
        }
        if (!MySql5PageHepler.isBracketCanPartnership(querySelect.substring(orderIndex, querySelect.length()))) {
            throw new RuntimeException("My SQL \u5206\u9875\u5fc5\u987b\u8981\u6709Order by \u8bed\u53e5!");
        }
        return orderIndex;
    }

    public static String getLimitString(String querySelect, int offset, int limit) {
        querySelect = MySql5PageHepler.getLineSql(querySelect);
        String sql = querySelect + " limit " + offset + " ," + limit;
        return sql;
    }

    private static String getLineSql(String sql) {
        return sql.replaceAll("[\r\n]", " ").replaceAll("\\s{2,}", " ");
    }

    private static int getAfterFormInsertPoint(String querySelect) {
        String regex = "\\s+FROM\\s+";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(querySelect);
        while (matcher.find()) {
            int fromStartIndex = matcher.start(0);
            String text = querySelect.substring(0, fromStartIndex);
            if (!MySql5PageHepler.isBracketCanPartnership(text)) continue;
            return fromStartIndex;
        }
        return 0;
    }

    private static boolean isBracketCanPartnership(String text) {
        return text != null && MySql5PageHepler.getIndexOfCount(text, '(') == MySql5PageHepler.getIndexOfCount(text, ')');
    }

    private static int getIndexOfCount(String text, char ch) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            count = text.charAt(i) == ch ? count + 1 : count;
        }
        return count;
    }
}

