/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.uuid.db;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.RowBounds;

public class Page<T>
extends RowBounds {
    protected int pageNo = 1;
    protected int pageSize = 10;
    protected int offset;
    protected int limit;
    protected List<T> result = new ArrayList<T>();
    protected int totalCount;
    protected int totalPages;

    private void calcOffset() {
        this.offset = (this.pageNo - 1) * this.pageSize;
    }

    private void calcLimit() {
        this.limit = this.pageSize;
    }

    public Page() {
        this.calcOffset();
        this.calcLimit();
    }

    public Page(int pageNo, int pageSize) {
        if (0 != pageNo) {
            this.pageNo = pageNo;
        }
        if (0 != pageSize) {
            this.pageSize = pageSize;
        }
        this.calcOffset();
        this.calcLimit();
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getFirst() {
        return (this.pageNo - 1) * this.pageSize + 1;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        this.totalPages = this.getTotalPages();
    }

    public int getTotalPages() {
        if (this.totalCount < 0) {
            return -1;
        }
        int pages = this.totalCount / this.pageSize;
        return this.totalCount % this.pageSize > 0 ? ++pages : pages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        this.calcOffset();
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.calcLimit();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String toString() {
        return "Page [pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", offset=" + this.offset + ", limit=" + this.limit + ", result=" + this.result + ", totalCount=" + this.totalCount + ", totalPages=" + this.totalPages + "]";
    }
}

