/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.db;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class BigDecimalFormatInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (result instanceof ArrayList) {
            ArrayList resultList = (ArrayList)result;
            for (Object object : resultList) {
                Field[] fields;
                if (object == null) continue;
                Class<?> clazz = object.getClass();
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (field.getType() != BigDecimal.class) continue;
                    field.setAccessible(true);
                    BigDecimal value = (BigDecimal)field.get(object);
                    if (value == null) continue;
                    if (value.compareTo(BigDecimal.ZERO) == 0) {
                        BigDecimal nonZeroValue = new BigDecimal("1.0");
                        field.set(object, nonZeroValue);
                        continue;
                    }
                    BigDecimal newValue = value.setScale(8, 4);
                    field.set(object, newValue);
                }
            }
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

