package com.ohaotian.plugin.es.builder.create;

import com.ohaotian.plugin.es.builder.Builder;
import com.ohaotian.plugin.es.builder.schema.DataType;
import java.util.LinkedList;
import java.util.List;

/**
 * @author pengys5
 */
public class ColumnsBuilder implements Builder<List<ColumnsBuilder.Column>> {

    private List<Column> columns;

    private ColumnsBuilder() {
        columns = new LinkedList<>();
    }

    public static ColumnsBuilder newBuilder() {
        return new ColumnsBuilder();
    }

    public ColumnsBuilder addCol(String name, DataType dataType) {
        columns.add(new Column(name, dataType));
        return this;
    }

    @Override public List<Column> build() {
        return columns;
    }

    public class Column {
        private final String name;
        private final DataType dataType;

        public Column(String name, DataType dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        public String getName() {
            return name;
        }

        public DataType getDataType() {
            return dataType;
        }
    }
}
