package com.ohaotian.plugin.es.elasticsearch.builder.search;

import com.ohaotian.plugin.es.builder.search.filter.BooleanFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.FilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.MatchFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.RangeFilterCondition;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;

/**
 * @author pengys5
 */
public enum ElasticSearchFilterBuilder {
    INSTANCE;

    public QueryBuilder build(FilterCondition condition) {
        if (condition instanceof MatchFilterCondition) {
            MatchFilterCondition matchCondition = (MatchFilterCondition)condition;
            return new MatchQueryBuilder(matchCondition.getColumnName(), matchCondition.getValue());
        } else if (condition instanceof BooleanFilterCondition) {
            BooleanFilterCondition booleanCondition = (BooleanFilterCondition)condition;

            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            for (FilterCondition filterCondition : booleanCondition.getMust()) {
                boolQueryBuilder.must(build(filterCondition));
            }
            for (FilterCondition filterCondition : booleanCondition.getShould()) {
                boolQueryBuilder.should(build(filterCondition));
            }
            return boolQueryBuilder;
        } else if (condition instanceof RangeFilterCondition) {
            RangeFilterCondition rangeCondition = (RangeFilterCondition)condition;
            RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(rangeCondition.getColumnName());
            if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.GT)) {
                rangeQueryBuilder.gt(rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.GTE)) {
                rangeQueryBuilder.gte(rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.LT)) {
                rangeQueryBuilder.lt(rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.LTE)) {
                rangeQueryBuilder.lte(rangeCondition.getValue());
            }
            return rangeQueryBuilder;
        } else {
            throw new RuntimeException("理论上不应该啊");
        }
    }
}